/*
 * Decompiled with CFR 0.152.
 */
package classycle.classfile;

import classycle.classfile.Constant;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class ConstantPoolPrinter {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: java classycle.classfile.ConstantPoolPrinter <class files>");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            ConstantPoolPrinter.investigate(stringArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void investigate(String string) {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new FileInputStream(string));
            Constant[] constantArray = Constant.extractConstantPool((DataInputStream)filterInputStream);
            ConstantPoolPrinter.printConstantPool(constantArray);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void printConstantPool(Constant[] constantArray) {
        for (int i = 0; i < constantArray.length; ++i) {
            System.out.println(i + ": " + constantArray[i]);
        }
    }
}

