/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.PackageProcessor;
import classycle.dependency.CyclesResult;
import classycle.dependency.Result;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.Statement;
import classycle.graph.AtomicVertex;
import classycle.graph.NameAttributes;
import classycle.graph.StrongComponent;
import classycle.graph.StrongComponentAnalyser;
import classycle.util.StringPattern;
import java.util.ArrayList;

public class CheckCyclesStatement
implements Statement {
    private final StringPattern _set;
    private final int _maximumSize;
    private final boolean _packageCycles;
    private final SetDefinitionRepository _repository;

    public CheckCyclesStatement(StringPattern stringPattern, int n, boolean bl, SetDefinitionRepository setDefinitionRepository) {
        this._set = stringPattern;
        this._maximumSize = n;
        this._packageCycles = bl;
        this._repository = setDefinitionRepository;
    }

    @Override
    public Result execute(AtomicVertex[] atomicVertexArray) {
        ArrayList<AtomicVertex> arrayList = new ArrayList<AtomicVertex>();
        for (int i = 0; i < atomicVertexArray.length; ++i) {
            if (!this._set.matches(((NameAttributes)atomicVertexArray[i].getAttributes()).getName())) continue;
            arrayList.add(atomicVertexArray[i]);
        }
        atomicVertexArray = arrayList.toArray(new AtomicVertex[0]);
        if (this._packageCycles) {
            PackageProcessor packageProcessor = new PackageProcessor();
            packageProcessor.deepSearchFirst(atomicVertexArray);
            atomicVertexArray = packageProcessor.getGraph();
        }
        StrongComponentAnalyser strongComponentAnalyser = new StrongComponentAnalyser(atomicVertexArray);
        StrongComponent[] strongComponentArray = strongComponentAnalyser.getCondensedGraph();
        CyclesResult cyclesResult = new CyclesResult(this.createStatement(), this._packageCycles);
        for (int i = 0; i < strongComponentArray.length; ++i) {
            StrongComponent strongComponent = strongComponentArray[i];
            if (strongComponent.getNumberOfVertices() <= this._maximumSize) continue;
            cyclesResult.addCycle(strongComponent);
        }
        return cyclesResult;
    }

    public String toString() {
        return this.createStatement();
    }

    private String createStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("check").append(' ');
        if (this._packageCycles) {
            stringBuffer.append("absenceOfPackageCycles");
        } else {
            stringBuffer.append("absenceOfClassCycles");
        }
        stringBuffer.append(" > ").append(this._maximumSize).append(' ');
        stringBuffer.append("in").append(' ');
        stringBuffer.append(this._repository.toString(this._set));
        return new String(stringBuffer);
    }
}

