/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.Result;
import classycle.graph.AtomicVertex;
import classycle.graph.NameAttributes;
import classycle.graph.StrongComponent;
import classycle.renderer.AbstractStrongComponentRenderer;
import java.util.ArrayList;
import java.util.List;

public class CyclesResult
implements Result {
    private final List<StrongComponent> _cycles = new ArrayList<StrongComponent>();
    private final String _statement;
    private final boolean _packageCycle;

    public CyclesResult(String string, boolean bl) {
        this._statement = string;
        this._packageCycle = bl;
    }

    public void addCycle(StrongComponent strongComponent) {
        this._cycles.add(strongComponent);
    }

    public List<StrongComponent> getCycles() {
        return this._cycles;
    }

    public String getStatement() {
        return this._statement;
    }

    public boolean isPackageCycle() {
        return this._packageCycle;
    }

    @Override
    public boolean isOk() {
        return this._cycles.size() == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this._statement);
        if (this.isOk()) {
            stringBuffer.append("\tOK");
        } else {
            for (StrongComponent strongComponent : this._cycles) {
                int n = strongComponent.getNumberOfVertices();
                stringBuffer.append("\n  ");
                stringBuffer.append(AbstractStrongComponentRenderer.createName(strongComponent));
                stringBuffer.append(" contains ").append(n);
                stringBuffer.append(' ').append(this._packageCycle ? "packages" : "classes").append(':');
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("\n    ");
                    AtomicVertex atomicVertex = strongComponent.getVertex(i);
                    stringBuffer.append(((NameAttributes)atomicVertex.getAttributes()).getName());
                }
            }
        }
        return new String(stringBuffer.append('\n'));
    }
}

