/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.Analyser;
import classycle.dependency.DependencyCheckerCommandLine;
import classycle.dependency.DependencyProcessor;
import classycle.dependency.DependencyProperties;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.graph.AtomicVertex;
import java.io.PrintWriter;
import java.util.Map;

public class DependencyChecker {
    private final Analyser _analyser;
    private final ResultRenderer _renderer;
    private final DependencyProcessor _processor;

    public DependencyChecker(Analyser analyser, String string, Map map, ResultRenderer resultRenderer) {
        this._analyser = analyser;
        this._renderer = resultRenderer;
        DependencyProperties dependencyProperties = new DependencyProperties(map);
        this._processor = new DependencyProcessor(string, dependencyProperties, resultRenderer);
    }

    public boolean check(PrintWriter printWriter) {
        Result result = this.check();
        printWriter.print(this._renderer.render(result));
        return result.isOk();
    }

    public Result check() {
        AtomicVertex[] atomicVertexArray = this._analyser.getClassGraph();
        ResultContainer resultContainer = new ResultContainer();
        while (this._processor.hasMoreStatements()) {
            resultContainer.add(this._processor.executeNextStatement(atomicVertexArray));
        }
        return resultContainer;
    }

    public static void main(String[] stringArray) {
        DependencyCheckerCommandLine dependencyCheckerCommandLine = new DependencyCheckerCommandLine(stringArray);
        if (!dependencyCheckerCommandLine.isValid()) {
            System.out.println("Usage: java -cp classycle.jar classycle.DependencyChecker " + dependencyCheckerCommandLine.getUsage());
            System.exit(1);
        }
        Analyser analyser = new Analyser(dependencyCheckerCommandLine.getClassFiles(), dependencyCheckerCommandLine.getPattern(), dependencyCheckerCommandLine.getReflectionPattern(), dependencyCheckerCommandLine.isMergeInnerClasses());
        DependencyChecker dependencyChecker = new DependencyChecker(analyser, dependencyCheckerCommandLine.getDependencyDefinition(), System.getProperties(), dependencyCheckerCommandLine.getRenderer());
        PrintWriter printWriter = new PrintWriter(System.out);
        boolean bl = dependencyChecker.check(printWriter);
        printWriter.flush();
        System.exit(bl ? 0 : 1);
    }
}

