/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DependencyPathsRenderer;
import classycle.dependency.Result;
import classycle.graph.AtomicVertex;
import classycle.graph.Vertex;
import classycle.util.StringPattern;

public class DependencyResult
implements Result {
    static final String OK = "\tOK";
    static final String DEPENDENCIES_FOUND = "\n  Unexpected dependencies found:";
    private final StringPattern _startSet;
    private final StringPattern _finalSet;
    private final String _statement;
    private final AtomicVertex[] _paths;
    private final boolean _ok;

    public DependencyResult(StringPattern stringPattern, StringPattern stringPattern2, String string, AtomicVertex[] atomicVertexArray) {
        this._startSet = stringPattern;
        this._finalSet = stringPattern2;
        this._statement = string;
        this._paths = atomicVertexArray;
        this._ok = atomicVertexArray.length == 0;
    }

    @Override
    public boolean isOk() {
        return this._ok;
    }

    public String getStatement() {
        return this._statement;
    }

    public StringPattern getFinalSet() {
        return this._finalSet;
    }

    public AtomicVertex[] getPaths() {
        return this._paths;
    }

    public StringPattern getStartSet() {
        return this._startSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this._statement);
        if (this._ok) {
            stringBuffer.append(OK);
        } else {
            DependencyPathsRenderer dependencyPathsRenderer = new DependencyPathsRenderer((Vertex[])this._paths, this._startSet, this._finalSet);
            stringBuffer.append(DEPENDENCIES_FOUND).append(dependencyPathsRenderer.renderGraph("  "));
        }
        return new String(stringBuffer.append('\n'));
    }
}

