/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DependencyResult;
import classycle.dependency.PatternVertexCondition;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.Statement;
import classycle.graph.AtomicVertex;
import classycle.graph.PathsFinder;
import classycle.graph.Vertex;
import classycle.graph.VertexCondition;
import classycle.util.OrStringPattern;
import classycle.util.StringPattern;
import java.util.HashSet;

public class DependencyStatement
implements Statement {
    private static final String CHECK = "check ";
    private final StringPattern[] _startSets;
    private final StringPattern[] _finalSets;
    private final StringPattern _finalSet;
    private final String _dependencyType;
    private final VertexCondition[] _startConditions;
    private final VertexCondition[] _finalConditions;
    private final VertexCondition _finalCondition;
    private final SetDefinitionRepository _repository;
    private final ResultRenderer _renderer;

    public DependencyStatement(StringPattern[] stringPatternArray, StringPattern[] stringPatternArray2, String string, SetDefinitionRepository setDefinitionRepository, ResultRenderer resultRenderer) {
        this._startSets = stringPatternArray;
        this._finalSets = stringPatternArray2;
        this._dependencyType = string;
        this._repository = setDefinitionRepository;
        this._renderer = resultRenderer;
        this._startConditions = this.createVertexConditions(stringPatternArray);
        this._finalConditions = this.createVertexConditions(stringPatternArray2);
        this._finalSet = new OrStringPattern(this._finalSets);
        this._finalCondition = new VertexUnionCondition(this._finalConditions);
    }

    private VertexCondition[] createVertexConditions(StringPattern[] stringPatternArray) {
        VertexCondition[] vertexConditionArray = new VertexCondition[stringPatternArray.length];
        for (int i = 0; i < vertexConditionArray.length; ++i) {
            vertexConditionArray[i] = new PatternVertexCondition(stringPatternArray[i]);
        }
        return vertexConditionArray;
    }

    @Override
    public Result execute(AtomicVertex[] atomicVertexArray) {
        ResultContainer resultContainer = new ResultContainer();
        boolean bl = "directlyIndependentOf".equals(this._dependencyType);
        boolean bl2 = "dependentOnlyOn".equals(this._dependencyType);
        for (int i = 0; i < this._startConditions.length; ++i) {
            VertexCondition vertexCondition = this._startConditions[i];
            StringPattern stringPattern = this._startSets[i];
            if (bl2) {
                HashSet<AtomicVertex> hashSet = new HashSet<AtomicVertex>();
                for (AtomicVertex atomicVertex : atomicVertexArray) {
                    if (!vertexCondition.isFulfilled(atomicVertex)) continue;
                    int n = atomicVertex.getNumberOfOutgoingArcs();
                    for (int j = 0; j < n; ++j) {
                        Vertex vertex = atomicVertex.getHeadVertex(j);
                        if (this._finalCondition.isFulfilled(vertex) || vertexCondition.isFulfilled(vertex)) continue;
                        hashSet.add(atomicVertex);
                        hashSet.add((AtomicVertex)vertex);
                    }
                }
                resultContainer.add(new DependencyResult(stringPattern, this._finalSet, this.toString(stringPattern, this._finalSet), hashSet.toArray(new AtomicVertex[0])));
                continue;
            }
            for (int j = 0; j < this._finalConditions.length; ++j) {
                PathsFinder pathsFinder = new PathsFinder(vertexCondition, this._finalConditions[j], this._renderer.onlyShortestPaths(), bl);
                resultContainer.add(new DependencyResult(stringPattern, this._finalSets[j], this.toString(i, j), pathsFinder.findPaths(atomicVertexArray)));
            }
        }
        return resultContainer;
    }

    private String toString(int n, int n2) {
        return this.toString(this._startSets[n], this._finalSets[n2]);
    }

    private String toString(StringPattern stringPattern, StringPattern stringPattern2) {
        StringBuffer stringBuffer = new StringBuffer(CHECK);
        stringBuffer.append(this._repository.toString(stringPattern)).append(' ').append(this._dependencyType).append(' ').append(this._repository.toString(stringPattern2));
        return new String(stringBuffer);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(CHECK);
        for (n = 0; n < this._startSets.length; ++n) {
            stringBuffer.append(this._repository.toString(this._startSets[n])).append(' ');
        }
        stringBuffer.append(this._dependencyType).append(' ');
        for (n = 0; n < this._finalSets.length; ++n) {
            stringBuffer.append(this._repository.toString(this._finalSets[n])).append(' ');
        }
        return new String(stringBuffer.substring(0, stringBuffer.length() - 1));
    }

    private static final class VertexUnionCondition
    implements VertexCondition {
        private final VertexCondition[] _conditions;

        VertexUnionCondition(VertexCondition[] vertexConditionArray) {
            this._conditions = vertexConditionArray;
        }

        @Override
        public boolean isFulfilled(Vertex vertex) {
            for (VertexCondition vertexCondition : this._conditions) {
                if (!vertexCondition.isFulfilled(vertex)) continue;
                return true;
            }
            return false;
        }
    }
}

