/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DependencyStatement;
import classycle.dependency.LayerDefinitionRepository;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.Statement;
import classycle.graph.AtomicVertex;
import classycle.util.StringPattern;

public class LayeringStatement
implements Statement {
    private final StringPattern[][] _layers;
    private final boolean _strictLayering;
    private final SetDefinitionRepository _repository;
    private final LayerDefinitionRepository _layerRepository;
    private final ResultRenderer _renderer;

    public LayeringStatement(StringPattern[][] stringPatternArray, boolean bl, SetDefinitionRepository setDefinitionRepository, LayerDefinitionRepository layerDefinitionRepository, ResultRenderer resultRenderer) {
        this._layers = stringPatternArray;
        this._repository = setDefinitionRepository;
        this._layerRepository = layerDefinitionRepository;
        this._strictLayering = bl;
        this._renderer = resultRenderer;
    }

    @Override
    public Result execute(AtomicVertex[] atomicVertexArray) {
        ResultContainer resultContainer = new ResultContainer();
        for (int i = 0; i < this._layers.length; ++i) {
            DependencyStatement dependencyStatement;
            int n;
            this.checkIntraLayerDependencies(resultContainer, this._layers[i], atomicVertexArray);
            for (n = i + 1; n < this._layers.length; ++n) {
                dependencyStatement = new DependencyStatement(this._layers[i], this._layers[n], "directlyIndependentOf", this._repository, this._renderer);
                resultContainer.add(dependencyStatement.execute(atomicVertexArray));
            }
            if (!this._strictLayering) continue;
            for (n = i - 2; n >= 0; --n) {
                dependencyStatement = new DependencyStatement(this._layers[i], this._layers[n], "directlyIndependentOf", this._repository, this._renderer);
                resultContainer.add(dependencyStatement.execute(atomicVertexArray));
            }
        }
        return resultContainer;
    }

    private void checkIntraLayerDependencies(ResultContainer resultContainer, StringPattern[] stringPatternArray, AtomicVertex[] atomicVertexArray) {
        StringPattern[] stringPatternArray2 = new StringPattern[1];
        StringPattern[] stringPatternArray3 = new StringPattern[stringPatternArray.length - 1];
        for (int i = 0; i < stringPatternArray.length; ++i) {
            stringPatternArray2[0] = stringPatternArray[i];
            System.arraycopy(stringPatternArray, 0, stringPatternArray3, 0, i);
            System.arraycopy(stringPatternArray, i + 1, stringPatternArray3, i, stringPatternArray.length - i - 1);
            DependencyStatement dependencyStatement = new DependencyStatement(stringPatternArray2, stringPatternArray3, "directlyIndependentOf", this._repository, this._renderer);
            resultContainer.add(dependencyStatement.execute(atomicVertexArray));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("check ");
        stringBuffer.append(this._strictLayering ? "strictLayeringOf" : "layeringOf");
        for (int i = 0; i < this._layers.length; ++i) {
            stringBuffer.append(' ').append(this._layerRepository.getName(this._layers[i]));
        }
        return new String(stringBuffer);
    }
}

