/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.Vertex;

public abstract class GraphProcessor {
    public void deepSearchFirst(Vertex[] vertexArray) {
        int n;
        this.initializeProcessing(vertexArray);
        for (n = 0; n < vertexArray.length; ++n) {
            vertexArray[n].reset();
        }
        for (n = 0; n < vertexArray.length; ++n) {
            if (vertexArray[n].isVisited()) continue;
            this.process(vertexArray[n]);
        }
        this.finishProcessing(vertexArray);
    }

    protected void process(Vertex vertex) {
        vertex.visit();
        this.processBefore(vertex);
        int n = vertex.getNumberOfOutgoingArcs();
        for (int i = 0; i < n; ++i) {
            this.processArc(vertex, vertex.getHeadVertex(i));
        }
        this.processAfter(vertex);
    }

    protected abstract void initializeProcessing(Vertex[] var1);

    protected abstract void processBefore(Vertex var1);

    protected abstract void processArc(Vertex var1, Vertex var2);

    protected abstract void processAfter(Vertex var1);

    protected abstract void finishProcessing(Vertex[] var1);
}

