/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.AtomicVertex;
import classycle.graph.Vertex;
import classycle.graph.VertexCondition;
import java.util.HashSet;

public class PathsFinder {
    private final VertexCondition _startSetCondition;
    private final VertexCondition _finalSetCondition;
    private final boolean _shortestPathsOnly;
    private final boolean _directPathsOnly;

    public PathsFinder(VertexCondition vertexCondition, VertexCondition vertexCondition2, boolean bl) {
        this(vertexCondition, vertexCondition2, bl, false);
    }

    public PathsFinder(VertexCondition vertexCondition, VertexCondition vertexCondition2, boolean bl, boolean bl2) {
        this._startSetCondition = vertexCondition;
        this._finalSetCondition = vertexCondition2;
        this._shortestPathsOnly = bl;
        this._directPathsOnly = bl2;
    }

    public VertexCondition getFinalSetCondition() {
        return this._finalSetCondition;
    }

    public boolean isShortestPathsOnly() {
        return this._shortestPathsOnly;
    }

    public VertexCondition getStartSetCondition() {
        return this._startSetCondition;
    }

    public AtomicVertex[] findPaths(AtomicVertex[] atomicVertexArray) {
        this.prepareGraph(atomicVertexArray);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        for (int i = 0; i < atomicVertexArray.length; ++i) {
            AtomicVertex atomicVertex = atomicVertexArray[i];
            if (!this._startSetCondition.isFulfilled(atomicVertex)) continue;
            if (this._directPathsOnly) {
                this.findDirectPaths(atomicVertex, hashSet);
                continue;
            }
            this.prepareIfFinal(atomicVertex);
            int n = this.calculateShortestPath(atomicVertex, hashSet2);
            if (n >= Integer.MAX_VALUE) continue;
            atomicVertex.setOrder(n);
            this.followPaths(atomicVertex, hashSet);
        }
        return hashSet.toArray(new AtomicVertex[hashSet.size()]);
    }

    private void findDirectPaths(AtomicVertex atomicVertex, HashSet hashSet) {
        if (this._finalSetCondition.isFulfilled(atomicVertex)) {
            hashSet.add(atomicVertex);
        } else {
            int n = atomicVertex.getNumberOfOutgoingArcs();
            for (int i = 0; i < n; ++i) {
                Vertex vertex = atomicVertex.getHeadVertex(i);
                if (!this._finalSetCondition.isFulfilled(vertex)) continue;
                hashSet.add(atomicVertex);
                hashSet.add(vertex);
            }
        }
    }

    private void prepareGraph(AtomicVertex[] atomicVertexArray) {
        for (int i = 0; i < atomicVertexArray.length; ++i) {
            AtomicVertex atomicVertex = atomicVertexArray[i];
            this.prepareVertex(atomicVertex);
            int n = atomicVertex.getNumberOfOutgoingArcs();
            for (int j = 0; j < n; ++j) {
                this.prepareVertex((AtomicVertex)atomicVertex.getHeadVertex(j));
            }
        }
    }

    private void prepareVertex(AtomicVertex atomicVertex) {
        atomicVertex.reset();
        atomicVertex.setOrder(Integer.MAX_VALUE);
        if (this._startSetCondition.isFulfilled(atomicVertex)) {
            atomicVertex.visit();
        }
    }

    private int calculateShortestPath(AtomicVertex atomicVertex, HashSet hashSet) {
        hashSet.add(atomicVertex);
        int n = Integer.MAX_VALUE;
        int n2 = atomicVertex.getNumberOfOutgoingArcs();
        for (int i = 0; i < n2; ++i) {
            int n3;
            AtomicVertex atomicVertex2 = (AtomicVertex)atomicVertex.getHeadVertex(i);
            this.prepareIfFinal(atomicVertex2);
            int n4 = n3 = this._startSetCondition.isFulfilled(atomicVertex2) ? Integer.MAX_VALUE : atomicVertex2.getOrder();
            if (!hashSet.contains(atomicVertex2) && !atomicVertex2.isVisited()) {
                n3 = this.calculateShortestPath(atomicVertex2, hashSet);
                atomicVertex2.setOrder(n3);
                atomicVertex2.visit();
            }
            n = Math.min(n, n3);
        }
        hashSet.remove(atomicVertex);
        if (n < Integer.MAX_VALUE) {
            ++n;
        }
        return n;
    }

    private void prepareIfFinal(AtomicVertex atomicVertex) {
        if (this._finalSetCondition.isFulfilled(atomicVertex)) {
            atomicVertex.visit();
            atomicVertex.setOrder(0);
        }
    }

    private void followPaths(AtomicVertex atomicVertex, HashSet hashSet) {
        hashSet.add(atomicVertex);
        int n = atomicVertex.getOrder() - 1;
        int n2 = atomicVertex.getNumberOfOutgoingArcs();
        for (int i = 0; i < n2; ++i) {
            AtomicVertex atomicVertex2 = (AtomicVertex)atomicVertex.getHeadVertex(i);
            int n3 = atomicVertex2.getOrder();
            if (n3 >= Integer.MAX_VALUE || hashSet.contains(atomicVertex2) || this._shortestPathsOnly && n3 != n) continue;
            hashSet.add(atomicVertex2);
            if (n3 <= 0) continue;
            this.followPaths(atomicVertex2, hashSet);
        }
    }
}

