/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.AtomicVertex;
import classycle.graph.Attributes;
import classycle.graph.GraphAttributes;
import classycle.graph.StrongComponentProcessor;
import classycle.graph.Vertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class StrongComponent
extends Vertex {
    private final Vector _vertices = new Vector();
    private boolean _active;
    private int _longestWalk;

    public StrongComponent() {
        super(new GeometryAttributes());
    }

    public int getNumberOfVertices() {
        return this._vertices.size();
    }

    public AtomicVertex getVertex(int n) {
        return (AtomicVertex)this._vertices.elementAt(n);
    }

    public void addVertex(AtomicVertex atomicVertex) {
        this._vertices.insertElementAt(atomicVertex, 0);
    }

    public void calculateAttributes() {
        int n;
        int n2;
        HashMap hashMap = this.calculateIndexMap();
        int[][] nArray = this.calculateDistances(hashMap);
        GeometryAttributes geometryAttributes = (GeometryAttributes)this.getAttributes();
        int n3 = Integer.MAX_VALUE;
        int[] nArray2 = new int[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n3 = Math.min(n3, nArray[n2][n2]);
            nArray2[n2] = 0;
            for (n = 0; n < nArray.length; ++n) {
                if (n2 == n) continue;
                nArray2[n2] = Math.max(nArray2[n2], nArray[n2][n]);
            }
        }
        geometryAttributes.setEccentricities(nArray2);
        geometryAttributes.setGirth(n3);
        geometryAttributes.setMaximumFragmentSizes(this.calculateMaximumFragmentSizes(hashMap));
        n = geometryAttributes.getRadius();
        int n4 = geometryAttributes.getBestFragmentSize();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray2[n2] == n) {
                geometryAttributes.addVertex(this.getVertex(n2));
            }
            if (geometryAttributes.getMaximumFragmentSizes()[n2] != n4) continue;
            geometryAttributes.addFragmenter(this.getVertex(n2));
        }
    }

    private int[][] calculateDistances(HashMap hashMap) {
        int n;
        int n2 = this.getNumberOfVertices();
        int[][] nArray = new int[n2][n2];
        for (n = 0; n < n2; ++n) {
            int n3;
            int[] nArray2 = nArray[n];
            AtomicVertex atomicVertex = this.getVertex(n);
            for (n3 = 0; n3 < n2; ++n3) {
                nArray2[n3] = 0x3FFFFFFF;
            }
            int n4 = atomicVertex.getNumberOfOutgoingArcs();
            for (n3 = 0; n3 < n4; ++n3) {
                Integer n5 = (Integer)hashMap.get(atomicVertex.getHeadVertex(n3));
                if (n5 == null) continue;
                nArray2[n5.intValue()] = 1;
            }
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (nArray[i][n] + nArray[n][j] >= nArray[i][j]) continue;
                    nArray[i][j] = nArray[i][n] + nArray[n][j];
                }
            }
        }
        return nArray;
    }

    private HashMap calculateIndexMap() {
        HashMap<AtomicVertex, Integer> hashMap = new HashMap<AtomicVertex, Integer>();
        int n = this.getNumberOfVertices();
        for (int i = 0; i < n; ++i) {
            hashMap.put(this.getVertex(i), new Integer(i));
        }
        return hashMap;
    }

    private int[] calculateMaximumFragmentSizes(HashMap hashMap) {
        int n;
        Object object;
        int n2;
        Vertex[] vertexArray = new AtomicVertex[this.getNumberOfVertices()];
        for (n2 = 0; n2 < vertexArray.length; ++n2) {
            vertexArray[n2] = new AtomicVertex(null);
        }
        for (n2 = 0; n2 < vertexArray.length; ++n2) {
            object = this.getVertex(n2);
            int n3 = ((Vertex)object).getNumberOfOutgoingArcs();
            for (n = 0; n < n3; ++n) {
                Integer n4 = (Integer)hashMap.get(((Vertex)object).getHeadVertex(n));
                if (n4 == null) continue;
                vertexArray[n2].addOutgoingArcTo(vertexArray[n4]);
            }
        }
        StrongComponentProcessor strongComponentProcessor = new StrongComponentProcessor(false);
        object = new int[this.getNumberOfVertices()];
        for (n = 0; n < ((Object)object).length; ++n) {
            vertexArray[n].setDefaultValueOfGraphVertexFlag(false);
            strongComponentProcessor.deepSearchFirst(vertexArray);
            StrongComponent[] strongComponentArray = strongComponentProcessor.getStrongComponents();
            object[n] = false;
            for (int i = 0; i < strongComponentArray.length; ++i) {
                object[n] = Math.max((int)object[n], strongComponentArray[i].getNumberOfVertices());
            }
            ((AtomicVertex)vertexArray[n]).setDefaultValueOfGraphVertexFlag(true);
        }
        return object;
    }

    @Override
    public void reset() {
        super.reset();
        this._active = false;
        this._longestWalk = -1;
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean bl) {
        this._active = bl;
    }

    public int getLongestWalk() {
        return this._longestWalk;
    }

    public void setLongestWalk(int n) {
        this._longestWalk = n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Strong component with ");
        int n = this.getNumberOfVertices();
        stringBuffer.append(n).append(n > 1 ? " vertices." : " vertex.");
        stringBuffer.append(" Longest walk: ").append(this.getLongestWalk());
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\n    ").append(this.getVertex(i));
        }
        return new String(stringBuffer);
    }

    private static class GeometryAttributes
    implements GraphAttributes {
        private int _girth;
        private int _radius;
        private int _diameter;
        private ArrayList _centerVertices = new ArrayList();
        private int[] _eccentricities;
        private int[] _maximumFragmentSizes;
        private int _bestFragmentSize;
        private ArrayList _bestFragmenters = new ArrayList();

        @Override
        public int getGirth() {
            return this._girth;
        }

        void setGirth(int n) {
            this._girth = n;
        }

        @Override
        public int getRadius() {
            return this._radius;
        }

        @Override
        public int getDiameter() {
            return this._diameter;
        }

        @Override
        public int getBestFragmentSize() {
            return this._bestFragmentSize;
        }

        @Override
        public Vertex[] getCenterVertices() {
            return this._centerVertices.toArray(new Vertex[this._centerVertices.size()]);
        }

        void addVertex(Vertex vertex) {
            this._centerVertices.add(vertex);
        }

        @Override
        public Vertex[] getBestFragmenters() {
            return this._bestFragmenters.toArray(new Vertex[this._bestFragmenters.size()]);
        }

        void addFragmenter(Vertex vertex) {
            this._bestFragmenters.add(vertex);
        }

        @Override
        public int[] getEccentricities() {
            return this._eccentricities;
        }

        void setEccentricities(int[] nArray) {
            this._eccentricities = nArray;
            this._radius = Integer.MAX_VALUE;
            this._diameter = 0;
            for (int i = 0; i < nArray.length; ++i) {
                this._radius = Math.min(this._radius, nArray[i]);
                this._diameter = Math.max(this._diameter, nArray[i]);
            }
        }

        @Override
        public int[] getMaximumFragmentSizes() {
            return this._maximumFragmentSizes;
        }

        void setMaximumFragmentSizes(int[] nArray) {
            this._maximumFragmentSizes = nArray;
            this._bestFragmentSize = Integer.MAX_VALUE;
            for (int i = 0; i < nArray.length; ++i) {
                this._bestFragmentSize = Math.min(this._bestFragmentSize, nArray[i]);
            }
        }

        public int compareTo(Object object) {
            ArrayList arrayList;
            int n = 1;
            if (object instanceof GeometryAttributes && this._bestFragmenters.size() > 0 && (arrayList = ((GeometryAttributes)object)._bestFragmenters).size() > 0) {
                Attributes attributes = ((Vertex)this._bestFragmenters.get(0)).getAttributes();
                Attributes attributes2 = ((Vertex)arrayList.get(0)).getAttributes();
                n = attributes.compareTo(attributes2);
            }
            return n;
        }
    }
}

