/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.AtomicVertex;
import classycle.graph.LongestWalkProcessor;
import classycle.graph.StrongComponent;
import classycle.graph.StrongComponentProcessor;
import classycle.graph.Vertex;
import java.util.HashMap;
import java.util.Map;

public class StrongComponentAnalyser {
    private final AtomicVertex[] _graph;
    private StrongComponent[] _components;
    private HashMap _layerMap;

    public StrongComponentAnalyser(AtomicVertex[] atomicVertexArray) {
        this._graph = atomicVertexArray;
    }

    public AtomicVertex[] getGraph() {
        return this._graph;
    }

    public StrongComponent[] getCondensedGraph() {
        if (this._components == null) {
            StrongComponentProcessor strongComponentProcessor = new StrongComponentProcessor(true);
            strongComponentProcessor.deepSearchFirst(this._graph);
            this._components = strongComponentProcessor.getStrongComponents();
        }
        return this._components;
    }

    public Map getLayerMap() {
        if (this._layerMap == null) {
            Vertex[] vertexArray = this.getCondensedGraph();
            new LongestWalkProcessor().deepSearchFirst(vertexArray);
            this._layerMap = new HashMap();
            for (int i = 0; i < vertexArray.length; ++i) {
                Vertex vertex = vertexArray[i];
                Integer n = new Integer(((StrongComponent)vertex).getLongestWalk());
                int n2 = ((StrongComponent)vertex).getNumberOfVertices();
                for (int j = 0; j < n2; ++j) {
                    this._layerMap.put(((StrongComponent)vertex).getVertex(j), n);
                }
            }
        }
        return this._layerMap;
    }
}

