/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.AtomicVertex;
import classycle.graph.GraphProcessor;
import classycle.graph.StrongComponent;
import classycle.graph.Vertex;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class StrongComponentProcessor
extends GraphProcessor {
    private final boolean _calculateAttributes;
    private int _counter;
    private Stack _vertexStack = new Stack();
    private Vector _strongComponents = new Vector();
    private Hashtable _vertexToComponents = new Hashtable();
    private StrongComponent[] _graph;

    public StrongComponentProcessor(boolean bl) {
        this._calculateAttributes = bl;
    }

    public StrongComponent[] getStrongComponents() {
        return this._graph;
    }

    @Override
    protected void initializeProcessing(Vertex[] vertexArray) {
        this._counter = 0;
        this._vertexStack.setSize(0);
        this._strongComponents.setSize(0);
        this._vertexToComponents.clear();
    }

    @Override
    protected void processBefore(Vertex vertex) {
        AtomicVertex atomicVertex = this.castAsAtomicVertex(vertex);
        atomicVertex.setOrder(this._counter);
        atomicVertex.setLow(this._counter++);
        this._vertexStack.push(atomicVertex);
    }

    @Override
    protected void processArc(Vertex vertex, Vertex vertex2) {
        AtomicVertex atomicVertex = this.castAsAtomicVertex(vertex);
        AtomicVertex atomicVertex2 = this.castAsAtomicVertex(vertex2);
        if (atomicVertex2.isGraphVertex()) {
            if (!atomicVertex2.isVisited()) {
                this.process(atomicVertex2);
                atomicVertex.setLow(Math.min(atomicVertex.getLow(), atomicVertex2.getLow()));
            } else if (atomicVertex2.getOrder() < atomicVertex.getOrder() && this._vertexStack.contains(atomicVertex2)) {
                atomicVertex.setLow(Math.min(atomicVertex.getLow(), atomicVertex2.getOrder()));
            }
        }
    }

    @Override
    protected void processAfter(Vertex vertex) {
        AtomicVertex atomicVertex = this.castAsAtomicVertex(vertex);
        if (atomicVertex.getLow() == atomicVertex.getOrder()) {
            StrongComponent strongComponent = new StrongComponent();
            while (!this._vertexStack.isEmpty() && ((AtomicVertex)this._vertexStack.peek()).getOrder() >= atomicVertex.getOrder()) {
                AtomicVertex atomicVertex2 = (AtomicVertex)this._vertexStack.pop();
                strongComponent.addVertex(atomicVertex2);
                this._vertexToComponents.put(atomicVertex2, strongComponent);
            }
            this._strongComponents.addElement(strongComponent);
        }
    }

    @Override
    protected void finishProcessing(Vertex[] vertexArray) {
        this._graph = new StrongComponent[this._strongComponents.size()];
        for (int i = 0; i < this._graph.length; ++i) {
            this._graph[i] = (StrongComponent)this._strongComponents.elementAt(i);
            if (!this._calculateAttributes) continue;
            this._graph[i].calculateAttributes();
        }
        Enumeration enumeration = this._vertexToComponents.keys();
        while (enumeration.hasMoreElements()) {
            AtomicVertex atomicVertex = (AtomicVertex)enumeration.nextElement();
            StrongComponent strongComponent = (StrongComponent)this._vertexToComponents.get(atomicVertex);
            int n = atomicVertex.getNumberOfOutgoingArcs();
            for (int i = 0; i < n; ++i) {
                StrongComponent strongComponent2;
                AtomicVertex atomicVertex2 = (AtomicVertex)atomicVertex.getHeadVertex(i);
                if (!atomicVertex2.isGraphVertex() || (strongComponent2 = (StrongComponent)this._vertexToComponents.get(atomicVertex2)) == null || strongComponent2 == strongComponent) continue;
                strongComponent.addOutgoingArcTo(strongComponent2);
            }
        }
    }

    private AtomicVertex castAsAtomicVertex(Vertex vertex) {
        if (vertex instanceof AtomicVertex) {
            return (AtomicVertex)vertex;
        }
        throw new IllegalArgumentException(vertex + " is not an instance of AtomicVertex");
    }
}

