/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.Attributes;
import java.util.Vector;

public class Vertex
implements Comparable {
    private final Vector _heads = new Vector();
    private final Vector _tails = new Vector();
    private final Attributes _attributes;
    private boolean _visited;

    public Vertex(Attributes attributes) {
        this._attributes = attributes;
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public int getNumberOfOutgoingArcs() {
        return this._heads.size();
    }

    public Vertex getHeadVertex(int n) {
        return (Vertex)this._heads.elementAt(n);
    }

    public void addOutgoingArcTo(Vertex vertex) {
        if (!this._heads.contains(vertex)) {
            this._heads.addElement(vertex);
            vertex.addIncomingArcTo(this);
        }
    }

    public int getNumberOfIncomingArcs() {
        return this._tails.size();
    }

    public Vertex getTailVertex(int n) {
        return (Vertex)this._tails.elementAt(n);
    }

    public void addIncomingArcTo(Vertex vertex) {
        if (!this._tails.contains(vertex)) {
            this._tails.addElement(vertex);
            vertex.addOutgoingArcTo(this);
        }
    }

    public void reset() {
        this._visited = false;
    }

    public void visit() {
        this._visited = true;
    }

    public boolean isVisited() {
        return this._visited;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getAttributes() == null ? super.toString() : this.getAttributes().toString()).append(": ").append(this.getNumberOfIncomingArcs()).append(" incoming arc(s), ").append(this.getNumberOfOutgoingArcs()).append(" outgoing arc(s).");
        return new String(stringBuffer);
    }

    public int compareTo(Object object) {
        int n = 1;
        if (object instanceof Vertex && this._attributes != null) {
            n = this._attributes.compareTo(((Vertex)object)._attributes);
        }
        return n;
    }
}

