/*
 * Decompiled with CFR 0.152.
 */
package classycle.renderer;

import classycle.graph.GraphAttributes;
import classycle.graph.NameAttributes;
import classycle.graph.StrongComponent;
import classycle.graph.Vertex;
import classycle.renderer.AbstractStrongComponentRenderer;
import java.text.FieldPosition;
import java.text.MessageFormat;

public class XMLStrongComponentRenderer
extends AbstractStrongComponentRenderer {
    private final int _minimumSize;

    protected String getStrongComponentElementName() {
        return "cycle";
    }

    protected String getNodesElementName() {
        return "classes";
    }

    protected String getNodeElementName() {
        return "classRef";
    }

    protected String getCenterNodesElementName() {
        return "centerClasses";
    }

    protected String getBestFragmentersElementName() {
        return "bestFragmenters";
    }

    private MessageFormat getStrongComponentElementTemplate() {
        return new MessageFormat("    <" + this.getStrongComponentElementName() + " name=\"{0}\" size=\"{1}\" longestWalk=\"{2}\"" + " girth=\"{3}\" radius=\"{4}\" diameter=\"{5}\"" + " bestFragmentSize=\"{6}\">\n");
    }

    private MessageFormat getNodeElementTemplate() {
        return new MessageFormat("        <" + this.getNodeElementName() + " name=\"{0}\"/>\n");
    }

    private MessageFormat getNodeElementTemplateWithEccentricity() {
        return new MessageFormat("        <" + this.getNodeElementName() + " name=\"{0}\" eccentricity=\"{1}\"" + " maximumFragmentSize=\"{2}\"/>\n");
    }

    public XMLStrongComponentRenderer(int n) {
        this._minimumSize = n;
    }

    @Override
    public String render(StrongComponent strongComponent) {
        StringBuffer stringBuffer = new StringBuffer();
        if (strongComponent.getNumberOfVertices() >= this._minimumSize) {
            Object[] objectArray = new String[7];
            objectArray[0] = XMLStrongComponentRenderer.createName(strongComponent);
            objectArray[1] = Integer.toString(strongComponent.getNumberOfVertices());
            objectArray[2] = Integer.toString(strongComponent.getLongestWalk());
            GraphAttributes graphAttributes = (GraphAttributes)strongComponent.getAttributes();
            objectArray[3] = Integer.toString(graphAttributes.getGirth());
            objectArray[4] = Integer.toString(graphAttributes.getRadius());
            objectArray[5] = Integer.toString(graphAttributes.getDiameter());
            objectArray[6] = Integer.toString(graphAttributes.getBestFragmentSize());
            this.getStrongComponentElementTemplate().format(objectArray, stringBuffer, (FieldPosition)null);
            this.renderClasses(strongComponent, stringBuffer);
            this.renderVertices(graphAttributes.getCenterVertices(), stringBuffer, this.getCenterNodesElementName());
            this.renderVertices(graphAttributes.getBestFragmenters(), stringBuffer, this.getBestFragmentersElementName());
            stringBuffer.append("    </").append(this.getStrongComponentElementName()).append(">\n");
        }
        return new String(stringBuffer);
    }

    private void renderClasses(StrongComponent strongComponent, StringBuffer stringBuffer) {
        stringBuffer.append("      <").append(this.getNodesElementName()).append(">\n");
        int[] nArray = ((GraphAttributes)strongComponent.getAttributes()).getEccentricities();
        int[] nArray2 = ((GraphAttributes)strongComponent.getAttributes()).getMaximumFragmentSizes();
        Object[] objectArray = new String[3];
        MessageFormat messageFormat = this.getNodeElementTemplateWithEccentricity();
        int n = strongComponent.getNumberOfVertices();
        for (int i = 0; i < n; ++i) {
            objectArray[0] = ((NameAttributes)strongComponent.getVertex(i).getAttributes()).getName();
            objectArray[1] = Integer.toString(nArray[i]);
            objectArray[2] = Integer.toString(nArray2[i]);
            messageFormat.format(objectArray, stringBuffer, (FieldPosition)null);
        }
        stringBuffer.append("      </").append(this.getNodesElementName()).append(">\n");
    }

    private void renderVertices(Vertex[] vertexArray, StringBuffer stringBuffer, String string) {
        stringBuffer.append("      <").append(string).append(">\n");
        Object[] objectArray = new String[1];
        MessageFormat messageFormat = this.getNodeElementTemplate();
        for (int i = 0; i < vertexArray.length; ++i) {
            objectArray[0] = ((NameAttributes)vertexArray[i].getAttributes()).getName();
            messageFormat.format(objectArray, stringBuffer, (FieldPosition)null);
        }
        stringBuffer.append("      </").append(string).append(">\n");
    }
}

