/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.connection.SimpleConnection;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.util.Assert;

public class PooledChannelConnectionFactory
extends AbstractConnectionFactory {
    private volatile ConnectionWrapper connection;
    private boolean simplePublisherConfirms;
    private BiConsumer<GenericObjectPool<Channel>, Boolean> poolConfigurer = (pool, tx) -> {};

    public PooledChannelConnectionFactory(ConnectionFactory rabbitConnectionFactory) {
        this(rabbitConnectionFactory, false);
    }

    private PooledChannelConnectionFactory(ConnectionFactory rabbitConnectionFactory, boolean isPublisher) {
        super(rabbitConnectionFactory);
        if (!isPublisher) {
            this.setPublisherConnectionFactory(new PooledChannelConnectionFactory(rabbitConnectionFactory, true));
        }
    }

    public void setPoolConfigurer(BiConsumer<GenericObjectPool<Channel>, Boolean> poolConfigurer) {
        Assert.notNull(poolConfigurer, (String)"'poolConfigurer' cannot be null");
        this.poolConfigurer = poolConfigurer;
    }

    @Override
    public boolean isSimplePublisherConfirms() {
        return this.simplePublisherConfirms;
    }

    public void setSimplePublisherConfirms(boolean simplePublisherConfirms) {
        this.simplePublisherConfirms = simplePublisherConfirms;
    }

    @Override
    public synchronized Connection createConnection() throws AmqpException {
        if (this.connection == null || !this.connection.isOpen()) {
            Connection bareConnection = this.createBareConnection();
            this.connection = new ConnectionWrapper(bareConnection.getDelegate(), this.getCloseTimeout(), this.simplePublisherConfirms, this.poolConfigurer);
        }
        return this.connection;
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        if (this.connection != null) {
            this.connection.forceClose();
            this.connection = null;
        }
    }

    private static final class ConnectionWrapper
    extends SimpleConnection {
        private static final Log LOGGER = LogFactory.getLog(ConnectionWrapper.class);
        private final ObjectPool<Channel> channels;
        private final ObjectPool<Channel> txChannels;
        private final boolean simplePublisherConfirms;

        ConnectionWrapper(com.rabbitmq.client.Connection delegate, int closeTimeout, boolean simplePublisherConfirms, BiConsumer<GenericObjectPool<Channel>, Boolean> configurer) {
            super(delegate, closeTimeout);
            GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new ChannelFactory());
            configurer.accept((GenericObjectPool<Channel>)pool, false);
            this.channels = pool;
            pool = new GenericObjectPool((PooledObjectFactory)new TxChannelFactory());
            configurer.accept((GenericObjectPool<Channel>)pool, true);
            this.txChannels = pool;
            this.simplePublisherConfirms = simplePublisherConfirms;
        }

        @Override
        public Channel createChannel(boolean transactional) {
            try {
                return transactional ? (Channel)this.txChannels.borrowObject() : (Channel)this.channels.borrowObject();
            }
            catch (Exception e) {
                throw RabbitExceptionTranslator.convertRabbitAccessException(e);
            }
        }

        private Channel createProxy(Channel channel, boolean transacted) {
            ProxyFactory pf = new ProxyFactory((Object)channel);
            AtomicReference<Channel> proxy = new AtomicReference<Channel>();
            AtomicBoolean confirmSelected = new AtomicBoolean();
            MethodInterceptor advice = invocation -> {
                String method;
                switch (method = invocation.getMethod().getName()) {
                    case "close": {
                        this.handleClose(channel, transacted, proxy);
                        return null;
                    }
                    case "getTargetChannel": {
                        return channel;
                    }
                    case "isTransactional": {
                        return transacted;
                    }
                    case "confirmSelect": {
                        confirmSelected.set(true);
                        return channel.confirmSelect();
                    }
                    case "isConfirmSelected": {
                        return confirmSelected.get();
                    }
                }
                return null;
            };
            NameMatchMethodPointcutAdvisor advisor = new NameMatchMethodPointcutAdvisor((Advice)advice);
            advisor.addMethodName("close");
            advisor.addMethodName("getTargetChannel");
            advisor.addMethodName("isTransactional");
            advisor.addMethodName("confirmSelect");
            advisor.addMethodName("isConfirmSelected");
            pf.addAdvisor((Advisor)advisor);
            pf.addInterface(ChannelProxy.class);
            proxy.set((Channel)pf.getProxy());
            return (Channel)proxy.get();
        }

        private void handleClose(Channel channel, boolean transacted, AtomicReference<Channel> proxy) throws Exception {
            if (!RabbitUtils.isPhysicalCloseRequired()) {
                if (transacted) {
                    this.txChannels.returnObject((Object)proxy.get());
                } else {
                    this.channels.returnObject((Object)proxy.get());
                }
            } else {
                this.physicalClose(channel);
            }
        }

        @Override
        public void close() {
        }

        void forceClose() {
            super.close();
            this.channels.close();
            this.txChannels.close();
        }

        private void physicalClose(Channel channel) {
            RabbitUtils.clearPhysicalCloseRequired();
            if (channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException | TimeoutException e) {
                    LOGGER.debug((Object)"Error on close", (Throwable)e);
                }
            }
        }

        private final class TxChannelFactory
        extends ChannelFactory {
            private TxChannelFactory() {
            }

            @Override
            public PooledObject<Channel> makeObject() {
                Channel channel = ConnectionWrapper.this.createProxy(ConnectionWrapper.super.createChannel(true), true);
                try {
                    channel.txSelect();
                }
                catch (IOException e) {
                    throw RabbitExceptionTranslator.convertRabbitAccessException(e);
                }
                return new DefaultPooledObject((Object)channel);
            }
        }

        private class ChannelFactory
        implements PooledObjectFactory<Channel> {
            private ChannelFactory() {
            }

            public PooledObject<Channel> makeObject() {
                Channel channel = ConnectionWrapper.this.createProxy(ConnectionWrapper.super.createChannel(false), false);
                if (ConnectionWrapper.this.simplePublisherConfirms) {
                    try {
                        channel.confirmSelect();
                    }
                    catch (IOException e) {
                        throw RabbitExceptionTranslator.convertRabbitAccessException(e);
                    }
                }
                return new DefaultPooledObject((Object)channel);
            }

            public void destroyObject(PooledObject<Channel> p) throws Exception {
                ((Channel)p.getObject()).close();
            }

            public boolean validateObject(PooledObject<Channel> p) {
                return ((Channel)p.getObject()).isOpen();
            }

            public void activateObject(PooledObject<Channel> p) {
            }

            public void passivateObject(PooledObject<Channel> p) {
            }
        }
    }
}

