/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.docs;

import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.DocumentedSpanAssertions;
import org.springframework.cloud.sleuth.docs.EventValue;
import org.springframework.cloud.sleuth.docs.ImmutableAssertingSpan;
import org.springframework.cloud.sleuth.docs.TagKey;

public interface AssertingSpan
extends Span {
    public DocumentedSpan getDocumentedSpan();

    public Span getDelegate();

    default public boolean isStarted() {
        return false;
    }

    @Override
    default public AssertingSpan tag(String key, String value) {
        DocumentedSpanAssertions.assertThatKeyIsValid(key, this.getDocumentedSpan());
        this.getDelegate().tag(key, value);
        return this;
    }

    default public AssertingSpan tag(TagKey key, String value) {
        DocumentedSpanAssertions.assertThatKeyIsValid(key, this.getDocumentedSpan());
        this.getDelegate().tag(key.getKey(), value);
        return this;
    }

    @Override
    default public AssertingSpan event(String value) {
        DocumentedSpanAssertions.assertThatEventIsValid(value, this.getDocumentedSpan());
        this.getDelegate().event(value);
        return this;
    }

    default public AssertingSpan event(EventValue value) {
        DocumentedSpanAssertions.assertThatEventIsValid(value, this.getDocumentedSpan());
        this.getDelegate().event(value.getValue());
        return this;
    }

    @Override
    default public AssertingSpan name(String name) {
        DocumentedSpanAssertions.assertThatNameIsValid(name, this.getDocumentedSpan());
        this.getDelegate().name(name);
        return this;
    }

    @Override
    default public boolean isNoop() {
        return this.getDelegate().isNoop();
    }

    @Override
    default public TraceContext context() {
        return this.getDelegate().context();
    }

    @Override
    default public AssertingSpan start() {
        this.getDelegate().start();
        return this;
    }

    @Override
    default public AssertingSpan error(Throwable throwable) {
        this.getDelegate().error(throwable);
        return this;
    }

    @Override
    default public void end() {
        DocumentedSpanAssertions.assertThatSpanStartedBeforeEnd(this);
        this.getDelegate().end();
    }

    @Override
    default public void abandon() {
        this.getDelegate().abandon();
    }

    @Override
    default public AssertingSpan remoteServiceName(String remoteServiceName) {
        this.getDelegate().remoteServiceName(remoteServiceName);
        return this;
    }

    @Override
    default public Span remoteIpAndPort(String ip, int port) {
        this.getDelegate().remoteIpAndPort(ip, port);
        return this;
    }

    public static AssertingSpan of(DocumentedSpan documentedSpan, Span span) {
        if (span == null) {
            return null;
        }
        if (span instanceof AssertingSpan) {
            return (AssertingSpan)span;
        }
        return new ImmutableAssertingSpan(documentedSpan, span);
    }

    public static AssertingSpan continueSpan(DocumentedSpan documentedSpan, Span span) {
        AssertingSpan assertingSpan = AssertingSpan.of(documentedSpan, span);
        if (assertingSpan == null) {
            return null;
        }
        ((ImmutableAssertingSpan)assertingSpan).isStarted = true;
        return assertingSpan;
    }

    public static <T extends Span> T unwrap(Span span) {
        if (span == null) {
            return null;
        }
        if (span instanceof AssertingSpan) {
            return (T)((AssertingSpan)span).getDelegate();
        }
        return (T)span;
    }
}

