/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.stream;

import java.net.InetAddress;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.stream.Host;
import org.springframework.cloud.sleuth.stream.HostLocator;
import org.springframework.util.Assert;

public class DiscoveryClientHostLocator
implements HostLocator {
    private DiscoveryClient client;

    public DiscoveryClientHostLocator(DiscoveryClient client) {
        this.client = client;
        Assert.notNull((Object)this.client, (String)"client");
    }

    @Override
    public Host locate(Span span) {
        ServiceInstance instance = this.client.getLocalServiceInstance();
        return new Host(instance.getServiceId(), this.getIpAddress(instance), instance.getPort());
    }

    private String getIpAddress(ServiceInstance instance) {
        try {
            InetAddress address = InetAddress.getByName(instance.getHost());
            return address.getHostAddress();
        }
        catch (Exception e) {
            return "0.0.0.0";
        }
    }
}

