/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.reflection;

import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public abstract class GenericsUtils {
    public static Class<?> getParameterType(Class<?> evaluatedClass, Class<?> interfaceClass, int position) {
        Class<Object> bindableType = null;
        Assert.isTrue((boolean)interfaceClass.isInterface(), (String)"'interfaceClass' must be an interface");
        if (!interfaceClass.isAssignableFrom(evaluatedClass)) {
            throw new IllegalStateException(evaluatedClass + " does not implement " + interfaceClass);
        }
        ResolvableType currentType = ResolvableType.forType(evaluatedClass);
        while (!Object.class.equals((Object)currentType.getRawClass()) && bindableType == null) {
            ResolvableType[] interfaces = currentType.getInterfaces();
            ResolvableType resolvableType = null;
            for (ResolvableType interfaceType : interfaces) {
                if (!interfaceClass.equals(interfaceType.getRawClass())) continue;
                resolvableType = interfaceType;
                break;
            }
            if (resolvableType == null) {
                currentType = currentType.getSuperType();
                continue;
            }
            ResolvableType[] generics = resolvableType.getGenerics();
            ResolvableType generic = generics[position];
            Class<Object> resolvedParameter = generic.resolve();
            if (resolvedParameter != null) {
                bindableType = resolvedParameter;
                continue;
            }
            bindableType = Object.class;
        }
        if (bindableType == null) {
            throw new IllegalStateException("Cannot find parameter of " + evaluatedClass.getName() + " for " + interfaceClass + " at position " + position);
        }
        return bindableType;
    }
}

