/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.mail.MailReceiver;
import org.springframework.integration.mail.MailTransportUtils;
import org.springframework.util.Assert;

public abstract class AbstractMailReceiver
implements MailReceiver,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final URLName url;
    private volatile int maxFetchSize = -1;
    private volatile Session session;
    private volatile Store store;
    private volatile Folder folder;
    private volatile Properties javaMailProperties = new Properties();
    protected volatile boolean initialized;
    private final Object initializationMonitor = new Object();
    private Authenticator javaMailAuthenticator;

    public AbstractMailReceiver(URLName urlName) {
        Assert.notNull((Object)urlName, (String)"urlName must not be null");
        this.url = urlName;
    }

    public AbstractMailReceiver(String url) {
        Assert.notNull((Object)url, (String)"url must not be null");
        this.url = new URLName(url);
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    public void setJavaMailAuthenticator(Authenticator javaMailAuthenticator) {
        this.javaMailAuthenticator = javaMailAuthenticator;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    protected Folder getFolder() {
        return this.folder;
    }

    protected abstract Message[] searchForNewMessages() throws MessagingException;

    protected abstract boolean shouldDeleteMessages();

    private void openSession() throws MessagingException {
        if (this.session == null) {
            this.session = Session.getInstance((Properties)this.javaMailProperties, (Authenticator)this.javaMailAuthenticator);
        }
        if (this.store == null) {
            this.store = this.session.getStore(this.url);
        }
        if (!this.store.isConnected()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("connecting to store [" + MailTransportUtils.toPasswordProtectedString(this.url) + "]"));
            }
            this.store.connect();
        }
    }

    protected void openFolder() throws MessagingException {
        this.openSession();
        if (this.folder == null) {
            this.folder = this.store.getFolder(this.url);
        }
        if (this.folder == null || !this.folder.exists()) {
            throw new IllegalStateException("no such folder [" + this.url.getFile() + "]");
        }
        if (this.folder.isOpen()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("opening folder [" + MailTransportUtils.toPasswordProtectedString(this.url) + "]"));
        }
        if (this.shouldDeleteMessages()) {
            this.folder.open(2);
        } else {
            this.folder.open(1);
        }
    }

    public synchronized Message[] receive() {
        try {
            this.openFolder();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("attempting to receive mail from folder [" + this.getFolder().getFullName() + "]"));
            }
            Message[] messages = this.searchForNewMessages();
            if (this.maxFetchSize > 0 && messages.length > this.maxFetchSize) {
                Message[] reducedMessages = new Message[this.maxFetchSize];
                System.arraycopy(messages, 0, reducedMessages, 0, this.maxFetchSize);
                messages = reducedMessages;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("found " + messages.length + " new messages"));
            }
            if (messages.length > 0) {
                this.fetchMessages(messages);
            }
            if (this.shouldDeleteMessages()) {
                this.deleteMessages(messages);
            }
            Message[] copiedMessages = new Message[messages.length];
            int i = 0;
            while (i < messages.length) {
                copiedMessages[i] = new MimeMessage((MimeMessage)messages[i]);
                ++i;
            }
            Message[] messageArray = copiedMessages;
            return messageArray;
        }
        catch (Exception e) {
            throw new org.springframework.integration.core.MessagingException("failure occurred while receiving from folder", (Throwable)e);
        }
        finally {
            MailTransportUtils.closeFolder(this.folder);
        }
    }

    protected void fetchMessages(Message[] messages) throws MessagingException {
        FetchProfile contentsProfile = new FetchProfile();
        contentsProfile.add(FetchProfile.Item.ENVELOPE);
        contentsProfile.add(FetchProfile.Item.CONTENT_INFO);
        contentsProfile.add(FetchProfile.Item.FLAGS);
        this.folder.fetch(messages, contentsProfile);
    }

    protected void deleteMessages(Message[] messages) throws MessagingException {
        int i = 0;
        while (i < messages.length) {
            messages[i].setFlag(Flags.Flag.DELETED, true);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        Object object = this.initializationMonitor;
        synchronized (object) {
            MailTransportUtils.closeFolder(this.folder);
            MailTransportUtils.closeService((Service)this.store);
            this.folder = null;
            this.store = null;
            this.initialized = false;
        }
    }

    public String toString() {
        return this.url.toString();
    }
}

