/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.integration.adapter.MessageMappingException;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessageHeaders;
import org.springframework.integration.message.MessageHandler;
import org.springframework.integration.message.MessageHandlingException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailSendingMessageHandler
implements MessageHandler {
    private final JavaMailSender mailSender;

    public MailSendingMessageHandler(JavaMailSender mailSender) {
        Assert.notNull((Object)mailSender, (String)"'mailSender' must not be null");
        this.mailSender = mailSender;
    }

    public final void handleMessage(Message<?> message) {
        MailMessage mailMessage = this.convertMessageToMailMessage(message);
        if (mailMessage instanceof SimpleMailMessage) {
            this.mailSender.send((SimpleMailMessage)mailMessage);
        } else if (mailMessage instanceof MimeMailMessage) {
            this.mailSender.send(((MimeMailMessage)mailMessage).getMimeMessage());
        } else {
            throw new IllegalArgumentException("Unsupported MailMessage type [" + mailMessage.getClass().getName() + "].");
        }
    }

    private MailMessage convertMessageToMailMessage(Message<?> message) {
        if (message.getPayload() instanceof MailMessage) {
            return (MailMessage)message.getPayload();
        }
        MailMessage mailMessage = null;
        if (message.getPayload() instanceof byte[]) {
            mailMessage = this.createMailMessageFromByteArrayMessage(message);
        } else if (message.getPayload() instanceof String) {
            mailMessage = new SimpleMailMessage();
            mailMessage.setText((String)message.getPayload());
        } else {
            throw new MessageHandlingException(message, "Unable to create MailMessage from payload type [" + message.getPayload().getClass().getName() + "], expected byte array or String.");
        }
        this.applyHeadersToMailMessage(mailMessage, message.getHeaders());
        return mailMessage;
    }

    private MailMessage createMailMessageFromByteArrayMessage(Message<byte[]> message) {
        String attachmentFileName = (String)message.getHeaders().get((Object)"springintegration_mail_attachmentFilename", String.class);
        if (attachmentFileName == null) {
            throw new MessageMappingException(message, "Header 'springintegration_mail_attachmentFilename' is required when mapping a Message with a byte array payload to a MailMessage.");
        }
        Integer multipartMode = (Integer)message.getHeaders().get((Object)"springintegration_mail_multipartMode", Integer.class);
        if (multipartMode == null) {
            multipartMode = 1;
        }
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, multipartMode.intValue());
            helper.addAttachment(attachmentFileName, (InputStreamSource)new ByteArrayResource((byte[])message.getPayload()));
            return new MimeMailMessage(helper);
        }
        catch (MessagingException e) {
            throw new MessageMappingException(message, "failed to create MimeMessage", (Throwable)e);
        }
    }

    private void applyHeadersToMailMessage(MailMessage mailMessage, MessageHeaders headers) {
        String replyTo;
        String from;
        String[] bcc;
        String[] to;
        String subject = (String)headers.get((Object)"springintegration_mail_subject", String.class);
        if (subject != null) {
            mailMessage.setSubject(subject);
        }
        Assert.state(((to = this.retrieveHeaderValueAsStringArray(headers, "springintegration_mail_to")) != null ? 1 : 0) != 0, (String)"no value available for the 'MailHeaders.TO' header");
        mailMessage.setTo(to);
        String[] cc = this.retrieveHeaderValueAsStringArray(headers, "springintegration_mail_cc");
        if (cc != null) {
            mailMessage.setCc(cc);
        }
        if ((bcc = this.retrieveHeaderValueAsStringArray(headers, "springintegration_mail_bcc")) != null) {
            mailMessage.setBcc(bcc);
        }
        if ((from = (String)headers.get((Object)"springintegration_mail_from", String.class)) != null) {
            mailMessage.setFrom(from);
        }
        if ((replyTo = (String)headers.get((Object)"springintegration_mail_replyTo", String.class)) != null) {
            mailMessage.setReplyTo(replyTo);
        }
    }

    private String[] retrieveHeaderValueAsStringArray(MessageHeaders headers, String key) {
        Object value = headers.get((Object)key);
        if (value != null) {
            if (value instanceof String[]) {
                return (String[])value;
            }
            if (value instanceof String) {
                return StringUtils.commaDelimitedListToStringArray((String)((String)value));
            }
        }
        return null;
    }
}

