/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ImapIdleChannelAdapterParser
extends AbstractSingleBeanDefinitionParser {
    private static final String BASE_PACKAGE = "org.springframework.integration.mail";

    protected String getBeanClassName(Element element) {
        return "org.springframework.integration.mail.ImapIdleChannelAdapter";
    }

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String autoStartup;
        String channel = element.getAttribute("channel");
        Assert.hasText((String)channel, (String)"the 'channel' attribute is required");
        builder.addConstructorArgReference(this.parseImapMailReceiver(element, parserContext));
        builder.addPropertyReference("outputChannel", channel);
        String taskExecutorRef = element.getAttribute("task-executor");
        if (StringUtils.hasText((String)taskExecutorRef)) {
            builder.addPropertyReference("taskExecutor", taskExecutorRef);
        }
        if (StringUtils.hasText((String)(autoStartup = element.getAttribute("auto-startup")))) {
            builder.addPropertyValue("autoStartup", (Object)autoStartup);
        }
    }

    private String parseImapMailReceiver(Element element, ParserContext parserContext) {
        String uri = element.getAttribute("store-uri");
        Assert.hasText((String)uri, (String)"the 'store-uri' attribute is required");
        BeanDefinitionBuilder receiverBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.mail.ImapMailReceiver");
        receiverBuilder.addConstructorArgValue((Object)uri);
        String propertiesRef = element.getAttribute("java-mail-properties");
        if (StringUtils.hasText((String)propertiesRef)) {
            receiverBuilder.addPropertyReference("javaMailProperties", propertiesRef);
        }
        receiverBuilder.addPropertyValue("shouldDeleteMessages", (Object)(!"false".equals(element.getAttribute("should-delete-messages")) ? 1 : 0));
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)receiverBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }
}

