/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class MailInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    private static final String BASE_PACKAGE = "org.springframework.integration.mail";

    protected String parseSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.mail.MailReceivingMessageSource");
        builder.addConstructorArgReference(this.parseMailReceiver(element, parserContext));
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }

    private String parseMailReceiver(Element element, ParserContext parserContext) {
        String mmpp;
        Element pollerElement;
        String storeUri = element.getAttribute("store-uri");
        Assert.hasText((String)storeUri, (String)"the 'store-uri' attribute is required");
        BeanDefinitionBuilder receiverBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.mail.config.MailReceiverFactoryBean");
        receiverBuilder.addPropertyValue("storeUri", (Object)storeUri);
        String propertiesRef = element.getAttribute("java-mail-properties");
        if (StringUtils.hasText((String)propertiesRef)) {
            receiverBuilder.addPropertyReference("javaMailProperties", propertiesRef);
        }
        if ((pollerElement = DomUtils.getChildElementByTagName((Element)element, (String)"poller")) != null && StringUtils.hasText((String)(mmpp = pollerElement.getAttribute("max-messages-per-poll")))) {
            receiverBuilder.addPropertyValue("maxFetchSize", (Object)mmpp);
        }
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)receiverBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }
}

