/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.transformer;

import java.util.HashMap;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessagingException;
import org.springframework.integration.message.MessageBuilder;
import org.springframework.integration.transformer.MessageTransformationException;
import org.springframework.integration.transformer.Transformer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMailMessageTransformer<T>
implements Transformer {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public Message<?> transform(Message<?> message) {
        Object payload = message.getPayload();
        if (!(payload instanceof javax.mail.Message)) {
            throw new MessageTransformationException(message, String.valueOf(this.getClass().getSimpleName()) + " requires a javax.mail.Message payload");
        }
        javax.mail.Message mailMessage = (javax.mail.Message)payload;
        MessageBuilder<T> builder = null;
        try {
            builder = this.doTransform(mailMessage);
        }
        catch (Exception e) {
            throw new MessageTransformationException(message, "failed to transform mail message", (Throwable)e);
        }
        if (builder == null) {
            throw new MessageTransformationException(message, "failed to transform mail message");
        }
        builder.copyHeaders(this.extractHeaderMapFromMailMessage(mailMessage));
        return builder.build();
    }

    protected abstract MessageBuilder<T> doTransform(javax.mail.Message var1) throws Exception;

    private Map<String, Object> extractHeaderMapFromMailMessage(javax.mail.Message mailMessage) {
        try {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("springintegration_mail_from", this.convertToString(mailMessage.getFrom()));
            headers.put("springintegration_mail_bcc", this.convertToStringArray(mailMessage.getRecipients(Message.RecipientType.BCC)));
            headers.put("springintegration_mail_cc", this.convertToStringArray(mailMessage.getRecipients(Message.RecipientType.CC)));
            headers.put("springintegration_mail_to", this.convertToStringArray(mailMessage.getRecipients(Message.RecipientType.TO)));
            headers.put("springintegration_mail_replyTo", this.convertToString(mailMessage.getReplyTo()));
            headers.put("springintegration_mail_subject", mailMessage.getSubject());
            return headers;
        }
        catch (Exception e) {
            throw new MessagingException("conversion of MailMessage headers failed", (Throwable)e);
        }
    }

    private String convertToString(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        Assert.state((addresses.length == 1 ? 1 : 0) != 0, (String)"expected a single value but received an Array");
        return addresses[0].toString();
    }

    private String[] convertToStringArray(Address[] addresses) {
        if (addresses != null) {
            String[] addressStrings = new String[addresses.length];
            int i = 0;
            while (i < addresses.length) {
                addressStrings[i] = addresses[i].toString();
                ++i;
            }
            return addressStrings;
        }
        return new String[0];
    }
}

