/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.transformer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.mail.Message;
import javax.mail.Multipart;
import org.springframework.integration.mail.transformer.AbstractMailMessageTransformer;
import org.springframework.integration.message.MessageBuilder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailToStringTransformer
extends AbstractMailMessageTransformer<String> {
    private volatile String charset = "UTF-8";

    public void setCharset(String charset) {
        Assert.notNull((Object)charset, (String)"charset must not be null");
        Assert.isTrue((boolean)Charset.isSupported(charset), (String)("unsupported charset '" + charset + "'"));
        this.charset = charset;
    }

    @Override
    protected MessageBuilder<String> doTransform(Message mailMessage) throws Exception {
        Object content = mailMessage.getContent();
        if (content instanceof String) {
            return MessageBuilder.withPayload((Object)((String)content));
        }
        if (content instanceof Multipart) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ((Multipart)content).writeTo((OutputStream)outputStream);
            return MessageBuilder.withPayload((Object)new String(outputStream.toByteArray(), this.charset));
        }
        throw new IllegalArgumentException("failed to transform contentType [" + mailMessage.getContentType() + "] to String.");
    }
}

