/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.log.LogAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.BatchMessageListener;
import org.springframework.kafka.listener.ConsumerSeekAware;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.adapter.BatchToRecordAdapter;
import org.springframework.kafka.listener.adapter.FilteringBatchMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.FilteringMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.listener.adapter.ReplyHeadersConfigurer;
import org.springframework.kafka.listener.adapter.RetryingMessageListenerAdapter;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractKafkaListenerEndpoint<K, V>
implements KafkaListenerEndpoint,
BeanFactoryAware,
InitializingBean {
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private String id;
    private String groupId;
    private final Collection<String> topics = new ArrayList<String>();
    private Pattern topicPattern;
    private final Collection<TopicPartitionOffset> topicPartitions = new ArrayList<TopicPartitionOffset>();
    private BeanFactory beanFactory;
    private BeanExpressionResolver resolver;
    private BeanExpressionContext expressionContext;
    private BeanResolver beanResolver;
    private String group;
    private RecordFilterStrategy<K, V> recordFilterStrategy;
    private boolean ackDiscarded;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<? extends Object> recoveryCallback;
    private boolean statefulRetry;
    private Boolean batchListener;
    private KafkaTemplate<?, ?> replyTemplate;
    private String clientIdPrefix;
    private Integer concurrency;
    private Boolean autoStartup;
    private ReplyHeadersConfigurer replyHeadersConfigurer;
    private Properties consumerProperties;
    private boolean splitIterables = true;
    private BatchToRecordAdapter<K, V> batchToRecordAdapter;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
        this.beanResolver = new BeanFactoryResolver(beanFactory);
    }

    @Nullable
    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Nullable
    protected BeanExpressionResolver getResolver() {
        return this.resolver;
    }

    @Nullable
    protected BeanExpressionContext getBeanExpressionContext() {
        return this.expressionContext;
    }

    @Nullable
    protected BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    @Nullable
    public String getGroupId() {
        return this.groupId;
    }

    public void setTopics(String ... topics) {
        Assert.notNull((Object)topics, (String)"'topics' must not be null");
        this.topics.clear();
        this.topics.addAll(Arrays.asList(topics));
    }

    @Override
    public Collection<String> getTopics() {
        return Collections.unmodifiableCollection(this.topics);
    }

    public void setTopicPartitions(TopicPartitionOffset ... topicPartitions) {
        Assert.notNull((Object)topicPartitions, (String)"'topics' must not be null");
        this.topicPartitions.clear();
        this.topicPartitions.addAll(Arrays.asList(topicPartitions));
    }

    @Override
    @Nullable
    public TopicPartitionOffset[] getTopicPartitionsToAssign() {
        return this.topicPartitions.toArray(new TopicPartitionOffset[0]);
    }

    public void setTopicPattern(Pattern topicPattern) {
        this.topicPattern = topicPattern;
    }

    @Override
    @Nullable
    public Pattern getTopicPattern() {
        return this.topicPattern;
    }

    @Override
    @Nullable
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isBatchListener() {
        return this.batchListener == null ? false : this.batchListener;
    }

    @Nullable
    public Boolean getBatchListener() {
        return this.batchListener;
    }

    public void setBatchListener(boolean batchListener) {
        this.batchListener = batchListener;
    }

    public void setReplyTemplate(KafkaTemplate<?, ?> replyTemplate) {
        this.replyTemplate = replyTemplate;
    }

    @Nullable
    protected KafkaTemplate<?, ?> getReplyTemplate() {
        return this.replyTemplate;
    }

    @Nullable
    protected RecordFilterStrategy<? super K, ? super V> getRecordFilterStrategy() {
        return this.recordFilterStrategy;
    }

    public void setRecordFilterStrategy(RecordFilterStrategy<? super K, ? super V> recordFilterStrategy) {
        this.recordFilterStrategy = recordFilterStrategy;
    }

    protected boolean isAckDiscarded() {
        return this.ackDiscarded;
    }

    public void setAckDiscarded(boolean ackDiscarded) {
        this.ackDiscarded = ackDiscarded;
    }

    @Nullable
    protected RetryTemplate getRetryTemplate() {
        return this.retryTemplate;
    }

    @Deprecated
    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    @Nullable
    protected RecoveryCallback<?> getRecoveryCallback() {
        return this.recoveryCallback;
    }

    public void setRecoveryCallback(RecoveryCallback<? extends Object> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    protected boolean isStatefulRetry() {
        return this.statefulRetry;
    }

    public void setStatefulRetry(boolean statefulRetry) {
        this.statefulRetry = statefulRetry;
    }

    @Override
    @Nullable
    public String getClientIdPrefix() {
        return this.clientIdPrefix;
    }

    public void setClientIdPrefix(String clientIdPrefix) {
        this.clientIdPrefix = clientIdPrefix;
    }

    @Override
    @Nullable
    public Integer getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    @Nullable
    public Boolean getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setReplyHeadersConfigurer(ReplyHeadersConfigurer replyHeadersConfigurer) {
        this.replyHeadersConfigurer = replyHeadersConfigurer;
    }

    @Override
    @Nullable
    public Properties getConsumerProperties() {
        return this.consumerProperties;
    }

    public void setConsumerProperties(Properties consumerProperties) {
        this.consumerProperties = consumerProperties;
    }

    @Override
    public boolean isSplitIterables() {
        return this.splitIterables;
    }

    public void setSplitIterables(boolean splitIterables) {
        this.splitIterables = splitIterables;
    }

    @Nullable
    protected BatchToRecordAdapter<K, V> getBatchToRecordAdapter() {
        return this.batchToRecordAdapter;
    }

    public void setBatchToRecordAdapter(BatchToRecordAdapter<K, V> batchToRecordAdapter) {
        this.batchToRecordAdapter = batchToRecordAdapter;
    }

    public void afterPropertiesSet() {
        boolean topicsEmpty = this.getTopics().isEmpty();
        boolean topicPartitionsEmpty = ObjectUtils.isEmpty((Object[])this.getTopicPartitionsToAssign());
        if (!topicsEmpty && !topicPartitionsEmpty) {
            throw new IllegalStateException("Topics or topicPartitions must be provided but not both for " + this);
        }
        if (!(this.topicPattern == null || topicsEmpty && topicPartitionsEmpty)) {
            throw new IllegalStateException("Only one of topics, topicPartitions or topicPattern must are allowed for " + this);
        }
        if (this.topicPattern == null && topicsEmpty && topicPartitionsEmpty) {
            throw new IllegalStateException("At least one of topics, topicPartitions or topicPattern must be provided for " + this);
        }
    }

    @Override
    public void setupListenerContainer(MessageListenerContainer listenerContainer, @Nullable MessageConverter messageConverter) {
        this.setupMessageListener(listenerContainer, messageConverter);
    }

    protected abstract MessagingMessageListenerAdapter<K, V> createMessageListener(MessageListenerContainer var1, @Nullable MessageConverter var2);

    private void setupMessageListener(MessageListenerContainer container, @Nullable MessageConverter messageConverter) {
        MessagingMessageListenerAdapter<K, V> adapter = this.createMessageListener(container, messageConverter);
        if (this.replyHeadersConfigurer != null) {
            adapter.setReplyHeadersConfigurer(this.replyHeadersConfigurer);
        }
        adapter.setSplitIterables(this.splitIterables);
        ConsumerSeekAware messageListener = adapter;
        boolean isBatchListener = this.isBatchListener();
        Assert.state((messageListener != null ? 1 : 0) != 0, () -> "Endpoint [" + this + "] must provide a non null message listener");
        Assert.state((this.retryTemplate == null || !isBatchListener ? 1 : 0) != 0, (String)"A 'RetryTemplate' is not supported with a batch listener; consider configuring the container with a suitably configured 'SeekToCurrentBatchErrorHandler' instead");
        if (this.retryTemplate != null) {
            messageListener = new RetryingMessageListenerAdapter((MessageListener)((Object)messageListener), this.retryTemplate, this.recoveryCallback, this.statefulRetry);
        }
        if (this.recordFilterStrategy != null) {
            if (isBatchListener) {
                if (messageListener.isConsumerRecords()) {
                    this.logger.warn(() -> "Filter strategy ignored when consuming 'ConsumerRecords' instead of a List" + (this.id != null ? " id: " + this.id : ""));
                } else {
                    messageListener = new FilteringBatchMessageListenerAdapter<K, V>((BatchMessageListener)((Object)messageListener), this.recordFilterStrategy, this.ackDiscarded);
                }
            } else {
                messageListener = new FilteringMessageListenerAdapter<K, V>((MessageListener)((Object)messageListener), this.recordFilterStrategy, this.ackDiscarded);
            }
        }
        container.setupMessageListener(messageListener);
    }

    protected StringBuilder getEndpointDescription() {
        StringBuilder result = new StringBuilder();
        return result.append(this.getClass().getSimpleName()).append("[").append(this.id).append("] topics=").append(this.topics).append("' | topicPartitions='").append(this.topicPartitions).append("' | topicPattern='").append(this.topicPattern).append("'");
    }

    public String toString() {
        return this.getEndpointDescription().toString();
    }
}

