/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.ConsumerAwareRecordRecoverer;
import org.springframework.kafka.listener.ExceptionClassifier;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.ListenerUtils;
import org.springframework.kafka.support.KafkaUtils;
import org.springframework.kafka.support.SendResult;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.concurrent.ListenableFuture;

public class DeadLetterPublishingRecoverer
extends ExceptionClassifier
implements ConsumerAwareRecordRecoverer {
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private static final BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition> DEFAULT_DESTINATION_RESOLVER = (cr, e) -> new TopicPartition(cr.topic() + ".DLT", cr.partition());
    private static final long FIVE = 5L;
    private static final long THIRTY = 30L;
    private final HeaderNames headerNames = this.getHeaderNames();
    private final boolean transactional;
    private final BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition> destinationResolver;
    private final Function<ProducerRecord<?, ?>, KafkaOperations<?, ?>> templateResolver;
    private boolean retainExceptionHeader;
    private BiFunction<ConsumerRecord<?, ?>, Exception, Headers> headersFunction = (rec, ex) -> null;
    private boolean verifyPartition = true;
    private Duration partitionInfoTimeout = Duration.ofSeconds(5L);
    private Duration waitForSendResultTimeout = Duration.ofSeconds(30L);
    private boolean appendOriginalHeaders = true;
    private boolean failIfSendResultIsError = true;
    private boolean throwIfNoDestinationReturned = false;
    private long timeoutBuffer = Duration.ofSeconds(5L).toMillis();
    private boolean stripPreviousExceptionHeaders = true;

    public DeadLetterPublishingRecoverer(KafkaOperations<? extends Object, ? extends Object> template) {
        this(template, DEFAULT_DESTINATION_RESOLVER);
    }

    public DeadLetterPublishingRecoverer(KafkaOperations<? extends Object, ? extends Object> template, BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition> destinationResolver) {
        this(Collections.singletonMap(Object.class, template), destinationResolver);
    }

    public DeadLetterPublishingRecoverer(Map<Class<?>, KafkaOperations<? extends Object, ? extends Object>> templates) {
        this(templates, DEFAULT_DESTINATION_RESOLVER);
    }

    public DeadLetterPublishingRecoverer(Map<Class<?>, KafkaOperations<? extends Object, ? extends Object>> templates, BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition> destinationResolver) {
        Assert.isTrue((!ObjectUtils.isEmpty(templates) ? 1 : 0) != 0, (String)"At least one template is required");
        Assert.notNull(destinationResolver, (String)"The destinationResolver cannot be null");
        KafkaOperations<? extends Object, ? extends Object> firstTemplate = templates.values().iterator().next();
        this.templateResolver = templates.size() == 1 ? producerRecord -> firstTemplate : producerRecord -> this.findTemplateForValue(producerRecord.value(), templates);
        this.transactional = firstTemplate.isTransactional();
        Boolean tx = this.transactional;
        Assert.isTrue((boolean)templates.values().stream().map(t -> t.isTransactional()).allMatch(t -> t.equals(tx)), (String)"All templates must have the same setting for transactional");
        this.destinationResolver = destinationResolver;
    }

    public DeadLetterPublishingRecoverer(Function<ProducerRecord<?, ?>, KafkaOperations<?, ?>> templateResolver, boolean transactional, BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition> destinationResolver) {
        Assert.notNull(templateResolver, (String)"The templateResolver cannot be null");
        Assert.notNull(destinationResolver, (String)"The destinationResolver cannot be null");
        this.transactional = transactional;
        this.destinationResolver = destinationResolver;
        this.templateResolver = templateResolver;
    }

    public void setRetainExceptionHeader(boolean retainExceptionHeader) {
        this.retainExceptionHeader = retainExceptionHeader;
    }

    public void setHeadersFunction(BiFunction<ConsumerRecord<?, ?>, Exception, Headers> headersFunction) {
        Assert.notNull(headersFunction, (String)"'headersFunction' cannot be null");
        this.headersFunction = headersFunction;
    }

    public void setVerifyPartition(boolean verifyPartition) {
        this.verifyPartition = verifyPartition;
    }

    public void setPartitionInfoTimeout(Duration partitionInfoTimeout) {
        Assert.notNull((Object)partitionInfoTimeout, (String)"'partitionInfoTimeout' cannot be null");
        this.partitionInfoTimeout = partitionInfoTimeout;
    }

    @Deprecated
    public void setReplaceOriginalHeaders(boolean replaceOriginalHeaders) {
        this.appendOriginalHeaders = replaceOriginalHeaders;
    }

    public void setAppendOriginalHeaders(boolean appendOriginalHeaders) {
        this.appendOriginalHeaders = appendOriginalHeaders;
    }

    public void setThrowIfNoDestinationReturned(boolean throwIfNoDestinationReturned) {
        this.throwIfNoDestinationReturned = throwIfNoDestinationReturned;
    }

    public void setFailIfSendResultIsError(boolean failIfSendResultIsError) {
        this.failIfSendResultIsError = failIfSendResultIsError;
    }

    public void setWaitForSendResultTimeout(Duration waitForSendResultTimeout) {
        this.waitForSendResultTimeout = waitForSendResultTimeout;
    }

    public void setTimeoutBuffer(long buffer) {
        this.timeoutBuffer = buffer;
    }

    public void setStripPreviousExceptionHeaders(boolean stripPreviousExceptionHeaders) {
        this.stripPreviousExceptionHeaders = stripPreviousExceptionHeaders;
    }

    @Override
    public void accept(ConsumerRecord<?, ?> record, @Nullable Consumer<?, ?> consumer, Exception exception) {
        TopicPartition tp = this.destinationResolver.apply(record, exception);
        if (tp == null) {
            this.maybeThrow(record, exception);
            this.logger.debug(() -> "Recovery of " + ListenerUtils.recordToString(record, true) + " skipped because destination resolver returned null");
            return;
        }
        if (tp.topic().equals(record.topic()) && !this.getClassifier().classify((Throwable)exception).booleanValue()) {
            this.logger.error((CharSequence)("Recovery of " + ListenerUtils.recordToString(record, true) + " skipped because not retryable exception " + exception.toString() + " and the destination resolver routed back to the same topic"));
            return;
        }
        if (consumer != null && this.verifyPartition) {
            tp = this.checkPartition(tp, consumer);
        }
        DeserializationException vDeserEx = ListenerUtils.getExceptionFromHeader(record, "springDeserializerExceptionValue", this.logger);
        DeserializationException kDeserEx = ListenerUtils.getExceptionFromHeader(record, "springDeserializerExceptionKey", this.logger);
        RecordHeaders headers = new RecordHeaders(record.headers().toArray());
        this.addAndEnhanceHeaders(record, exception, vDeserEx, kDeserEx, (Headers)headers);
        ProducerRecord<Object, Object> outRecord = this.createProducerRecord(record, tp, (Headers)headers, kDeserEx == null ? null : kDeserEx.getData(), vDeserEx == null ? null : vDeserEx.getData());
        KafkaOperations<Object, Object> kafkaTemplate = this.templateResolver.apply(outRecord);
        this.sendOrThrow(outRecord, kafkaTemplate, record);
    }

    private void addAndEnhanceHeaders(ConsumerRecord<?, ?> record, Exception exception, @Nullable DeserializationException vDeserEx, @Nullable DeserializationException kDeserEx, Headers headers) {
        if (kDeserEx != null) {
            if (!this.retainExceptionHeader) {
                headers.remove("springDeserializerExceptionKey");
            }
            this.addExceptionInfoHeaders(headers, (Exception)((Object)kDeserEx), true);
        }
        if (vDeserEx != null) {
            if (!this.retainExceptionHeader) {
                headers.remove("springDeserializerExceptionValue");
            }
            this.addExceptionInfoHeaders(headers, (Exception)((Object)vDeserEx), false);
        }
        if (kDeserEx == null && vDeserEx == null) {
            this.addExceptionInfoHeaders(headers, exception, false);
        }
        this.enhanceHeaders(headers, record, exception);
    }

    private void sendOrThrow(ProducerRecord<Object, Object> outRecord, @Nullable KafkaOperations<Object, Object> kafkaTemplate, ConsumerRecord<?, ?> inRecord) {
        if (kafkaTemplate == null) {
            throw new IllegalArgumentException("No kafka template returned for record " + outRecord);
        }
        this.send(outRecord, kafkaTemplate, inRecord);
    }

    private void maybeThrow(ConsumerRecord<?, ?> record, Exception exception) {
        String message = String.format("No destination returned for record %s and exception %s. failIfNoDestinationReturned: %s", ListenerUtils.recordToString(record), exception, this.throwIfNoDestinationReturned);
        this.logger.warn((CharSequence)message);
        if (this.throwIfNoDestinationReturned) {
            throw new IllegalArgumentException(message);
        }
    }

    protected void send(ProducerRecord<Object, Object> outRecord, KafkaOperations<Object, Object> kafkaTemplate, ConsumerRecord<?, ?> inRecord) {
        if (this.transactional && !kafkaTemplate.inTransaction() && !kafkaTemplate.isAllowNonTransactional()) {
            kafkaTemplate.executeInTransaction(t -> {
                this.publish(outRecord, t, inRecord);
                return null;
            });
        } else {
            this.publish(outRecord, kafkaTemplate, inRecord);
        }
    }

    private TopicPartition checkPartition(TopicPartition tp, Consumer<?, ?> consumer) {
        if (tp.partition() < 0) {
            return tp;
        }
        try {
            List partitions = consumer.partitionsFor(tp.topic(), this.partitionInfoTimeout);
            if (partitions == null) {
                this.logger.debug(() -> "Could not obtain partition info for " + tp.topic());
                return tp;
            }
            boolean anyMatch = partitions.stream().anyMatch(pi -> pi.partition() == tp.partition());
            if (!anyMatch) {
                this.logger.warn(() -> "Destination resolver returned non-existent partition " + tp + ", KafkaProducer will determine partition to use for this topic");
                return new TopicPartition(tp.topic(), -1);
            }
            return tp;
        }
        catch (Exception ex) {
            this.logger.debug((Throwable)ex, () -> "Could not obtain partition info for " + tp.topic());
            return tp;
        }
    }

    private KafkaOperations<Object, Object> findTemplateForValue(@Nullable Object value, Map<Class<?>, KafkaOperations<?, ?>> templates) {
        if (value == null) {
            KafkaOperations<Object, Object> operations = templates.get(Void.class);
            if (operations == null) {
                return templates.values().iterator().next();
            }
            return operations;
        }
        Optional<Class> key = templates.keySet().stream().filter(k -> k.isAssignableFrom(value.getClass())).findFirst();
        if (key.isPresent()) {
            return templates.get(key.get());
        }
        this.logger.warn(() -> "Failed to find a template for " + value.getClass() + " attempting to use the last entry");
        return templates.values().stream().reduce((first, second) -> second).get();
    }

    protected ProducerRecord<Object, Object> createProducerRecord(ConsumerRecord<?, ?> record, TopicPartition topicPartition, Headers headers, @Nullable byte[] key, @Nullable byte[] value) {
        return new ProducerRecord(topicPartition.topic(), topicPartition.partition() < 0 ? null : Integer.valueOf(topicPartition.partition()), (Object)(key != null ? key : (byte[])record.key()), (Object)(value != null ? value : (byte[])record.value()), (Iterable)headers);
    }

    protected void publish(ProducerRecord<Object, Object> outRecord, KafkaOperations<Object, Object> kafkaTemplate, ConsumerRecord<?, ?> inRecord) {
        ListenableFuture<SendResult<Object, Object>> sendResult = null;
        try {
            sendResult = kafkaTemplate.send(outRecord);
            sendResult.addCallback(result -> this.logger.debug(() -> "Successful dead-letter publication: " + ListenerUtils.recordToString(inRecord, true) + " to " + result.getRecordMetadata()), ex -> this.logger.error(ex, () -> this.pubFailMessage(outRecord, inRecord)));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, () -> this.pubFailMessage(outRecord, inRecord));
        }
        if (this.failIfSendResultIsError) {
            this.verifySendResult(kafkaTemplate, outRecord, sendResult, inRecord);
        }
    }

    private void verifySendResult(KafkaOperations<Object, Object> kafkaTemplate, ProducerRecord<Object, Object> outRecord, @Nullable ListenableFuture<SendResult<Object, Object>> sendResult, ConsumerRecord<?, ?> inRecord) {
        Duration sendTimeout = this.determineSendTimeout(kafkaTemplate);
        if (sendResult == null) {
            throw new KafkaException(this.pubFailMessage(outRecord, inRecord));
        }
        try {
            sendResult.get(sendTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KafkaException(this.pubFailMessage(outRecord, inRecord), e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new KafkaException(this.pubFailMessage(outRecord, inRecord), e);
        }
    }

    private String pubFailMessage(ProducerRecord<Object, Object> outRecord, ConsumerRecord<?, ?> inRecord) {
        return "Dead-letter publication to " + outRecord.topic() + "failed for: " + ListenerUtils.recordToString(inRecord, true);
    }

    private Duration determineSendTimeout(KafkaOperations<?, ?> template) {
        Map<String, Object> props;
        ProducerFactory<?, ?> producerFactory = template.getProducerFactory();
        if (producerFactory != null && (props = producerFactory.getConfigurationProperties()) != null) {
            return KafkaUtils.determineSendTimeout(props, this.timeoutBuffer, this.waitForSendResultTimeout.toMillis());
        }
        return Duration.ofSeconds(30L);
    }

    private void enhanceHeaders(Headers kafkaHeaders, ConsumerRecord<?, ?> record, Exception exception) {
        this.maybeAddOriginalHeaders(kafkaHeaders, record, exception);
        Headers headers = this.headersFunction.apply(record, exception);
        if (headers != null) {
            headers.forEach(arg_0 -> ((Headers)kafkaHeaders).add(arg_0));
        }
    }

    private void maybeAddOriginalHeaders(Headers kafkaHeaders, ConsumerRecord<?, ?> record, Exception ex) {
        String consumerGroup;
        this.maybeAddHeader(kafkaHeaders, ((HeaderNames)this.headerNames).original.topicHeader, record.topic().getBytes(StandardCharsets.UTF_8));
        this.maybeAddHeader(kafkaHeaders, ((HeaderNames)this.headerNames).original.partitionHeader, ByteBuffer.allocate(4).putInt(record.partition()).array());
        this.maybeAddHeader(kafkaHeaders, ((HeaderNames)this.headerNames).original.offsetHeader, ByteBuffer.allocate(8).putLong(record.offset()).array());
        this.maybeAddHeader(kafkaHeaders, ((HeaderNames)this.headerNames).original.timestampHeader, ByteBuffer.allocate(8).putLong(record.timestamp()).array());
        this.maybeAddHeader(kafkaHeaders, ((HeaderNames)this.headerNames).original.timestampTypeHeader, record.timestampType().toString().getBytes(StandardCharsets.UTF_8));
        if (ex instanceof ListenerExecutionFailedException && (consumerGroup = ((ListenerExecutionFailedException)((Object)ex)).getGroupId()) != null) {
            this.maybeAddHeader(kafkaHeaders, ((HeaderNames)this.headerNames).original.consumerGroup, consumerGroup.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void maybeAddHeader(Headers kafkaHeaders, String header, byte[] value) {
        if (this.appendOriginalHeaders || kafkaHeaders.lastHeader(header) == null) {
            kafkaHeaders.add(header, value);
        }
    }

    void addExceptionInfoHeaders(Headers kafkaHeaders, Exception exception, boolean isKey) {
        String message;
        this.appendOrReplace(kafkaHeaders, new RecordHeader(isKey ? ((HeaderNames)this.headerNames).exceptionInfo.keyExceptionFqcn : ((HeaderNames)this.headerNames).exceptionInfo.exceptionFqcn, exception.getClass().getName().getBytes(StandardCharsets.UTF_8)));
        if (!isKey && exception.getCause() != null) {
            this.appendOrReplace(kafkaHeaders, new RecordHeader(((HeaderNames)this.headerNames).exceptionInfo.exceptionCauseFqcn, exception.getCause().getClass().getName().getBytes(StandardCharsets.UTF_8)));
        }
        if ((message = exception.getMessage()) != null) {
            this.appendOrReplace(kafkaHeaders, new RecordHeader(isKey ? ((HeaderNames)this.headerNames).exceptionInfo.keyExceptionMessage : ((HeaderNames)this.headerNames).exceptionInfo.exceptionMessage, exception.getMessage().getBytes(StandardCharsets.UTF_8)));
        }
        this.appendOrReplace(kafkaHeaders, new RecordHeader(isKey ? ((HeaderNames)this.headerNames).exceptionInfo.keyExceptionStacktrace : ((HeaderNames)this.headerNames).exceptionInfo.exceptionStacktrace, this.getStackTraceAsString(exception).getBytes(StandardCharsets.UTF_8)));
    }

    private void appendOrReplace(Headers headers, RecordHeader header) {
        if (this.stripPreviousExceptionHeaders) {
            headers.remove(header.key());
        }
        headers.add((Header)header);
    }

    private String getStackTraceAsString(Throwable cause) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        cause.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    protected HeaderNames getHeaderNames() {
        return HeaderNames.Builder.original().offsetHeader("kafka_dlt-original-offset").timestampHeader("kafka_dlt-original-timestamp").timestampTypeHeader("kafka_dlt-original-timestamp-type").topicHeader("kafka_dlt-original-topic").partitionHeader("kafka_dlt-original-partition").consumerGroupHeader("kafka_dlt-original-consumer-group").exception().keyExceptionFqcn("kafka_dlt-key-exception-fqcn").exceptionFqcn("kafka_dlt-exception-fqcn").exceptionCauseFqcn("kafka_dlt-exception-cause-fqcn").keyExceptionMessage("kafka_dlt-key-exception-message").exceptionMessage("kafka_dlt-exception-message").keyExceptionStacktrace("kafka_dlt-key-exception-stacktrace").exceptionStacktrace("kafka_dlt-exception-stacktrace").build();
    }

    public static class HeaderNames {
        private final Original original;
        private final ExceptionInfo exceptionInfo;

        HeaderNames(Original original, ExceptionInfo exceptionInfo) {
            this.original = original;
            this.exceptionInfo = exceptionInfo;
        }

        public static class Builder {
            private final Original original = new Original();
            private final ExceptionInfo exceptionInfo = new ExceptionInfo();

            public static Original original() {
                return new Builder().original;
            }

            public class ExceptionInfo {
                private String keyExceptionFqcn;
                private String exceptionFqcn;
                private String exceptionCauseFqcn;
                private String keyExceptionMessage;
                private String exceptionMessage;
                private String keyExceptionStacktrace;
                private String exceptionStacktrace;

                public ExceptionInfo keyExceptionFqcn(String keyExceptionFqcn) {
                    this.keyExceptionFqcn = keyExceptionFqcn;
                    return this;
                }

                public ExceptionInfo exceptionFqcn(String exceptionFqcn) {
                    this.exceptionFqcn = exceptionFqcn;
                    return this;
                }

                public ExceptionInfo exceptionCauseFqcn(String exceptionCauseFqcn) {
                    this.exceptionCauseFqcn = exceptionCauseFqcn;
                    return this;
                }

                public ExceptionInfo keyExceptionMessage(String keyExceptionMessage) {
                    this.keyExceptionMessage = keyExceptionMessage;
                    return this;
                }

                public ExceptionInfo exceptionMessage(String exceptionMessage) {
                    this.exceptionMessage = exceptionMessage;
                    return this;
                }

                public ExceptionInfo keyExceptionStacktrace(String keyExceptionStacktrace) {
                    this.keyExceptionStacktrace = keyExceptionStacktrace;
                    return this;
                }

                public ExceptionInfo exceptionStacktrace(String exceptionStacktrace) {
                    this.exceptionStacktrace = exceptionStacktrace;
                    return this;
                }

                public HeaderNames build() {
                    Assert.notNull((Object)this.keyExceptionFqcn, (String)"keyExceptionFqcn header cannot be null");
                    Assert.notNull((Object)this.exceptionFqcn, (String)"exceptionFqcn header cannot be null");
                    Assert.notNull((Object)this.exceptionCauseFqcn, (String)"exceptionCauseFqcn header cannot be null");
                    Assert.notNull((Object)this.keyExceptionMessage, (String)"keyExceptionMessage header cannot be null");
                    Assert.notNull((Object)this.exceptionMessage, (String)"exceptionMessage header cannot be null");
                    Assert.notNull((Object)this.keyExceptionStacktrace, (String)"keyExceptionStacktrace header cannot be null");
                    Assert.notNull((Object)this.exceptionStacktrace, (String)"exceptionStacktrace header cannot be null");
                    return new HeaderNames(Builder.this.original.build(), new org.springframework.kafka.listener.DeadLetterPublishingRecoverer$HeaderNames$ExceptionInfo(this.keyExceptionFqcn, this.exceptionFqcn, this.exceptionCauseFqcn, this.keyExceptionMessage, this.exceptionMessage, this.keyExceptionStacktrace, this.exceptionStacktrace));
                }
            }

            public class Original {
                private String offsetHeader;
                private String timestampHeader;
                private String timestampTypeHeader;
                private String topicHeader;
                private String partitionHeader;
                private String consumerGroupHeader;

                public Original offsetHeader(String offsetHeader) {
                    this.offsetHeader = offsetHeader;
                    return this;
                }

                public Original timestampHeader(String timestampHeader) {
                    this.timestampHeader = timestampHeader;
                    return this;
                }

                public Original timestampTypeHeader(String timestampTypeHeader) {
                    this.timestampTypeHeader = timestampTypeHeader;
                    return this;
                }

                public Original topicHeader(String topicHeader) {
                    this.topicHeader = topicHeader;
                    return this;
                }

                public Original partitionHeader(String partitionHeader) {
                    this.partitionHeader = partitionHeader;
                    return this;
                }

                public Original consumerGroupHeader(String consumerGroupHeader) {
                    this.consumerGroupHeader = consumerGroupHeader;
                    return this;
                }

                public ExceptionInfo exception() {
                    return Builder.this.exceptionInfo;
                }

                private org.springframework.kafka.listener.DeadLetterPublishingRecoverer$HeaderNames$Original build() {
                    Assert.notNull((Object)this.offsetHeader, (String)"offsetHeader cannot be null");
                    Assert.notNull((Object)this.timestampHeader, (String)"timestampHeader cannot be null");
                    Assert.notNull((Object)this.timestampTypeHeader, (String)"timestampTypeHeader cannot be null");
                    Assert.notNull((Object)this.topicHeader, (String)"topicHeader cannot be null");
                    Assert.notNull((Object)this.partitionHeader, (String)"partitionHeader cannot be null");
                    Assert.notNull((Object)this.consumerGroupHeader, (String)"consumerGroupHeader cannot be null");
                    return new org.springframework.kafka.listener.DeadLetterPublishingRecoverer$HeaderNames$Original(this.offsetHeader, this.timestampHeader, this.timestampTypeHeader, this.topicHeader, this.partitionHeader, this.consumerGroupHeader);
                }
            }
        }

        static class ExceptionInfo {
            final String keyExceptionFqcn;
            final String exceptionFqcn;
            final String exceptionCauseFqcn;
            final String keyExceptionMessage;
            final String exceptionMessage;
            final String keyExceptionStacktrace;
            final String exceptionStacktrace;

            ExceptionInfo(String keyExceptionFqcn, String exceptionFqcn, String exceptionCauseFqcn, String keyExceptionMessage, String exceptionMessage, String keyExceptionStacktrace, String exceptionStacktrace) {
                this.keyExceptionFqcn = keyExceptionFqcn;
                this.exceptionFqcn = exceptionFqcn;
                this.exceptionCauseFqcn = exceptionCauseFqcn;
                this.keyExceptionMessage = keyExceptionMessage;
                this.exceptionMessage = exceptionMessage;
                this.keyExceptionStacktrace = keyExceptionStacktrace;
                this.exceptionStacktrace = exceptionStacktrace;
            }
        }

        static class Original {
            final String offsetHeader;
            final String timestampHeader;
            final String timestampTypeHeader;
            final String topicHeader;
            final String partitionHeader;
            final String consumerGroup;

            Original(String offsetHeader, String timestampHeader, String timestampTypeHeader, String topicHeader, String partitionHeader, String consumerGroup) {
                this.offsetHeader = offsetHeader;
                this.timestampHeader = timestampHeader;
                this.timestampTypeHeader = timestampTypeHeader;
                this.topicHeader = topicHeader;
                this.partitionHeader = partitionHeader;
                this.consumerGroup = consumerGroup;
            }
        }
    }
}

