/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.config;

import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.restdocs.config.AbstractNestedConfigurer;
import org.springframework.restdocs.config.RestDocumentationConfigurer;
import org.springframework.restdocs.config.RestDocumentationContext;

public class SnippetConfigurer
extends AbstractNestedConfigurer<RestDocumentationConfigurer> {
    public static final String DEFAULT_SNIPPET_ENCODING = "UTF-8";
    private String snippetEncoding = "UTF-8";

    SnippetConfigurer(RestDocumentationConfigurer parent) {
        super(parent);
    }

    public SnippetConfigurer withEncoding(String encoding) {
        this.snippetEncoding = encoding;
        return this;
    }

    @Override
    void apply(MockHttpServletRequest request) {
        RestDocumentationContext context = RestDocumentationContext.currentContext();
        if (context != null) {
            context.setSnippetEncoding(this.snippetEncoding);
        }
    }
}

