/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.config;

import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.restdocs.config.AbstractNestedConfigurer;
import org.springframework.restdocs.config.RestDocumentationConfigurer;
import org.springframework.util.StringUtils;

public class UriConfigurer
extends AbstractNestedConfigurer<RestDocumentationConfigurer> {
    public static final String DEFAULT_SCHEME = "http";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_CONTEXT_PATH = "";
    private String scheme = "http";
    private String host = "localhost";
    private int port = 8080;
    private String contextPath = "";

    protected UriConfigurer(RestDocumentationConfigurer parent) {
        super(parent);
    }

    public UriConfigurer withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public UriConfigurer withHost(String host) {
        this.host = host;
        return this;
    }

    public UriConfigurer withPort(int port) {
        this.port = port;
        return this;
    }

    public UriConfigurer withContextPath(String contextPath) {
        this.contextPath = StringUtils.hasText((String)contextPath) && !contextPath.startsWith("/") ? "/" + contextPath : contextPath;
        return this;
    }

    @Override
    void apply(MockHttpServletRequest request) {
        request.setScheme(this.scheme);
        request.setServerPort(this.port);
        request.setServerName(this.host);
        request.setContextPath(this.contextPath);
    }
}

