/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SaveContextOnUpdateOrErrorResponseWrapper;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class HttpSessionSecurityContextRepository
implements SecurityContextRepository {
    public static final String SPRING_SECURITY_CONTEXT_KEY = "SPRING_SECURITY_CONTEXT";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Class<? extends SecurityContext> securityContextClass = null;
    private final Object contextObject = SecurityContextHolder.createEmptyContext();
    private boolean allowSessionCreation = true;
    private boolean disableUrlRewriting = false;
    private String springSecurityContextKey = "SPRING_SECURITY_CONTEXT";
    private final AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();

    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        HttpServletRequest request = requestResponseHolder.getRequest();
        HttpServletResponse response = requestResponseHolder.getResponse();
        HttpSession httpSession = request.getSession(false);
        SecurityContext context = this.readSecurityContextFromSession(httpSession);
        if (context == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No SecurityContext was available from the HttpSession: " + httpSession + ". " + "A new one will be created."));
            }
            context = this.generateNewContext();
        }
        requestResponseHolder.setResponse((HttpServletResponse)new SaveToSessionResponseWrapper(response, request, httpSession != null, context));
        return context;
    }

    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
        SaveContextOnUpdateOrErrorResponseWrapper responseWrapper = (SaveContextOnUpdateOrErrorResponseWrapper)response;
        if (!responseWrapper.isContextSaved()) {
            responseWrapper.saveContext(context);
        }
    }

    public boolean containsContext(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        return session.getAttribute(this.springSecurityContextKey) != null;
    }

    private SecurityContext readSecurityContextFromSession(HttpSession httpSession) {
        boolean debug = this.logger.isDebugEnabled();
        if (httpSession == null) {
            if (debug) {
                this.logger.debug((Object)"No HttpSession currently exists");
            }
            return null;
        }
        Object contextFromSession = httpSession.getAttribute(this.springSecurityContextKey);
        if (contextFromSession == null) {
            if (debug) {
                this.logger.debug((Object)"HttpSession returned null object for SPRING_SECURITY_CONTEXT");
            }
            return null;
        }
        if (!(contextFromSession instanceof SecurityContext)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)(this.springSecurityContextKey + " did not contain a SecurityContext but contained: '" + contextFromSession + "'; are you improperly modifying the HttpSession directly " + "(you should always use SecurityContextHolder) or using the HttpSession attribute " + "reserved for this class?"));
            }
            return null;
        }
        if (debug) {
            this.logger.debug((Object)("Obtained a valid SecurityContext from " + this.springSecurityContextKey + ": '" + contextFromSession + "'"));
        }
        return (SecurityContext)contextFromSession;
    }

    SecurityContext generateNewContext() {
        SecurityContext context = null;
        if (this.securityContextClass == null) {
            context = SecurityContextHolder.createEmptyContext();
            return context;
        }
        try {
            context = this.securityContextClass.newInstance();
        }
        catch (Exception e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        return context;
    }

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    public void setDisableUrlRewriting(boolean disableUrlRewriting) {
        this.disableUrlRewriting = disableUrlRewriting;
    }

    public void setSpringSecurityContextKey(String springSecurityContextKey) {
        Assert.hasText((String)springSecurityContextKey, (String)"springSecurityContextKey cannot be empty");
        this.springSecurityContextKey = springSecurityContextKey;
    }

    final class SaveToSessionResponseWrapper
    extends SaveContextOnUpdateOrErrorResponseWrapper {
        private final HttpServletRequest request;
        private final boolean httpSessionExistedAtStartOfRequest;
        private final SecurityContext contextBeforeExecution;
        private final Authentication authBeforeExecution;

        SaveToSessionResponseWrapper(HttpServletResponse response, HttpServletRequest request, boolean httpSessionExistedAtStartOfRequest, SecurityContext context) {
            super(response, HttpSessionSecurityContextRepository.this.disableUrlRewriting);
            this.request = request;
            this.httpSessionExistedAtStartOfRequest = httpSessionExistedAtStartOfRequest;
            this.contextBeforeExecution = context;
            this.authBeforeExecution = context.getAuthentication();
        }

        protected void saveContext(SecurityContext context) {
            Authentication authentication = context.getAuthentication();
            HttpSession httpSession = this.request.getSession(false);
            if (authentication == null || HttpSessionSecurityContextRepository.this.authenticationTrustResolver.isAnonymous(authentication)) {
                if (HttpSessionSecurityContextRepository.this.logger.isDebugEnabled()) {
                    HttpSessionSecurityContextRepository.this.logger.debug((Object)"SecurityContext is empty or contents are anonymous - context will not be stored in HttpSession.");
                }
                if (httpSession != null) {
                    httpSession.removeAttribute(HttpSessionSecurityContextRepository.this.springSecurityContextKey);
                }
                return;
            }
            if (httpSession == null) {
                httpSession = this.createNewSessionIfAllowed(context);
            }
            if (httpSession != null && (this.contextChanged(context) || httpSession.getAttribute(HttpSessionSecurityContextRepository.this.springSecurityContextKey) == null)) {
                httpSession.setAttribute(HttpSessionSecurityContextRepository.this.springSecurityContextKey, (Object)context);
                if (HttpSessionSecurityContextRepository.this.logger.isDebugEnabled()) {
                    HttpSessionSecurityContextRepository.this.logger.debug((Object)("SecurityContext stored to HttpSession: '" + context + "'"));
                }
            }
        }

        private boolean contextChanged(SecurityContext context) {
            return context != this.contextBeforeExecution || context.getAuthentication() != this.authBeforeExecution;
        }

        private HttpSession createNewSessionIfAllowed(SecurityContext context) {
            if (this.httpSessionExistedAtStartOfRequest) {
                if (HttpSessionSecurityContextRepository.this.logger.isDebugEnabled()) {
                    HttpSessionSecurityContextRepository.this.logger.debug((Object)"HttpSession is now null, but was not null at start of request; session was invalidated, so do not create a new session");
                }
                return null;
            }
            if (!HttpSessionSecurityContextRepository.this.allowSessionCreation) {
                if (HttpSessionSecurityContextRepository.this.logger.isDebugEnabled()) {
                    HttpSessionSecurityContextRepository.this.logger.debug((Object)("The HttpSession is currently null, and the " + HttpSessionSecurityContextRepository.class.getSimpleName() + " is prohibited from creating an HttpSession " + "(because the allowSessionCreation property is false) - SecurityContext thus not " + "stored for next request"));
                }
                return null;
            }
            if (HttpSessionSecurityContextRepository.this.contextObject.equals(context)) {
                if (HttpSessionSecurityContextRepository.this.logger.isDebugEnabled()) {
                    HttpSessionSecurityContextRepository.this.logger.debug((Object)("HttpSession is null, but SecurityContext has not changed from default empty context: ' " + context + "'; not creating HttpSession or storing SecurityContext"));
                }
                return null;
            }
            if (HttpSessionSecurityContextRepository.this.logger.isDebugEnabled()) {
                HttpSessionSecurityContextRepository.this.logger.debug((Object)"HttpSession being created as SecurityContext is non-default");
            }
            try {
                return this.request.getSession(true);
            }
            catch (IllegalStateException e) {
                HttpSessionSecurityContextRepository.this.logger.warn((Object)"Failed to create a session, as response has been committed. Unable to store SecurityContext.");
                return null;
            }
        }
    }
}

