/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import java.io.Serializable;
import org.springframework.aop.TargetSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HotSwappableTargetSource
implements TargetSource,
Serializable {
    private static final long serialVersionUID = 7497929212653839187L;
    private Object target;

    public HotSwappableTargetSource(Object initialTarget) {
        Assert.notNull((Object)initialTarget, (String)"Target object must not be null");
        this.target = initialTarget;
    }

    @Override
    public synchronized Class<?> getTargetClass() {
        return this.target.getClass();
    }

    @Override
    public synchronized Object getTarget() {
        return this.target;
    }

    public synchronized Object swap(Object newTarget) throws IllegalArgumentException {
        Assert.notNull((Object)newTarget, (String)"Target object must not be null");
        Object old = this.target;
        this.target = newTarget;
        return old;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof HotSwappableTargetSource)) return false;
        HotSwappableTargetSource that = (HotSwappableTargetSource)other;
        if (!this.target.equals(that.target)) return false;
        return true;
    }

    public int hashCode() {
        return HotSwappableTargetSource.class.hashCode();
    }

    public String toString() {
        return "HotSwappableTargetSource for target: " + this.target;
    }
}

