/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class AbstractJackson2Codec {
    public static final String JSON_VIEW_HINT = AbstractJackson2Codec.class.getName() + ".jsonView";
    protected static final List<MimeType> JSON_MIME_TYPES = Arrays.asList(new MimeType("application", "json", StandardCharsets.UTF_8), new MimeType("application", "*+json", StandardCharsets.UTF_8));
    protected final ObjectMapper mapper;

    protected AbstractJackson2Codec(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        this.mapper = mapper;
    }

    protected JavaType getJavaType(Type type, Class<?> contextClass) {
        TypeFactory typeFactory = this.mapper.getTypeFactory();
        if (contextClass != null) {
            ResolvableType resolvedType = ResolvableType.forType((Type)type);
            if (type instanceof TypeVariable) {
                ResolvableType resolvedTypeVariable = this.resolveVariable((TypeVariable)type, ResolvableType.forClass(contextClass));
                if (resolvedTypeVariable != ResolvableType.NONE) {
                    return typeFactory.constructType((Type)resolvedTypeVariable.resolve());
                }
            } else if (type instanceof ParameterizedType && resolvedType.hasUnresolvableGenerics()) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class[] generics = new Class[parameterizedType.getActualTypeArguments().length];
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                for (int i = 0; i < typeArguments.length; ++i) {
                    Type typeArgument = typeArguments[i];
                    if (typeArgument instanceof TypeVariable) {
                        ResolvableType resolvedTypeArgument = this.resolveVariable((TypeVariable)typeArgument, ResolvableType.forClass(contextClass));
                        if (resolvedTypeArgument != ResolvableType.NONE) {
                            generics[i] = resolvedTypeArgument.resolve();
                            continue;
                        }
                        generics[i] = ResolvableType.forType((Type)typeArgument).resolve();
                        continue;
                    }
                    generics[i] = ResolvableType.forType((Type)typeArgument).resolve();
                }
                return typeFactory.constructType(ResolvableType.forClassWithGenerics((Class)resolvedType.getRawClass(), (Class[])generics).getType());
            }
        }
        return typeFactory.constructType(type);
    }

    private ResolvableType resolveVariable(TypeVariable<?> typeVariable, ResolvableType contextType) {
        ResolvableType resolvedType;
        if (contextType.hasGenerics() && (resolvedType = ResolvableType.forType(typeVariable, (ResolvableType)contextType)).resolve() != null) {
            return resolvedType;
        }
        resolvedType = this.resolveVariable(typeVariable, contextType.getSuperType());
        if (resolvedType.resolve() != null) {
            return resolvedType;
        }
        for (ResolvableType ifc : contextType.getInterfaces()) {
            resolvedType = this.resolveVariable(typeVariable, ifc);
            if (resolvedType.resolve() == null) continue;
            return resolvedType;
        }
        return ResolvableType.NONE;
    }
}

