/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.patterns;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.web.util.patterns.PathElement;
import org.springframework.web.util.patterns.PathPattern;
import org.springframework.web.util.patterns.SubSequence;

class CaptureVariablePathElement
extends PathElement {
    private String variableName;
    private Pattern constraintPattern;

    CaptureVariablePathElement(int pos, char[] captureDescriptor, boolean caseSensitive) {
        super(pos);
        int colon = -1;
        for (int i = 0; i < captureDescriptor.length; ++i) {
            if (captureDescriptor[i] != ':') continue;
            colon = i;
            break;
        }
        if (colon == -1) {
            this.variableName = new String(captureDescriptor, 1, captureDescriptor.length - 2);
        } else {
            this.variableName = new String(captureDescriptor, 1, colon - 1);
            this.constraintPattern = caseSensitive ? Pattern.compile(new String(captureDescriptor, colon + 1, captureDescriptor.length - colon - 2)) : Pattern.compile(new String(captureDescriptor, colon + 1, captureDescriptor.length - colon - 2), 2);
        }
    }

    @Override
    public boolean matches(int candidateIndex, PathPattern.MatchingContext matchingContext) {
        int nextPos = matchingContext.scanAhead(candidateIndex);
        SubSequence candidateCapture = null;
        if (this.constraintPattern != null) {
            candidateCapture = new SubSequence(matchingContext.candidate, candidateIndex, nextPos);
            Matcher m = this.constraintPattern.matcher(candidateCapture);
            if (m.groupCount() != 0) {
                throw new IllegalArgumentException("No capture groups allowed in the constraint regex: " + this.constraintPattern.pattern());
            }
            if (!m.matches()) {
                return false;
            }
        }
        boolean match = false;
        match = this.next == null ? nextPos == matchingContext.candidateLength && nextPos > candidateIndex : (matchingContext.isMatchStartMatching && nextPos == matchingContext.candidateLength ? true : this.next.matches(nextPos, matchingContext));
        if (match && matchingContext.extractingVariables) {
            matchingContext.set(this.variableName, new String(matchingContext.candidate, candidateIndex, nextPos - candidateIndex));
        }
        return match;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String toString() {
        return "CaptureVariable({" + this.variableName + (this.constraintPattern == null ? "" : ":" + this.constraintPattern.pattern()) + "})";
    }

    @Override
    public int getNormalizedLength() {
        return 1;
    }

    @Override
    public int getWildcardCount() {
        return 0;
    }

    @Override
    public int getCaptureCount() {
        return 1;
    }

    @Override
    public int getScore() {
        return 1;
    }
}

