/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.socket.config.WebSocketNamespaceUtils;
import org.springframework.web.socket.server.support.OriginHandshakeInterceptor;
import org.springframework.web.socket.server.support.WebSocketHttpRequestHandler;
import org.springframework.web.socket.sockjs.support.SockJsHttpRequestHandler;
import org.w3c.dom.Element;

class HandlersBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String SOCK_JS_SCHEDULER_NAME = "SockJsScheduler";
    private static final int DEFAULT_MAPPING_ORDER = 1;

    HandlersBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext context) {
        HandlerMappingStrategy strategy;
        Object source = context.extractSource((Object)element);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        context.pushContainingComponent(compDefinition);
        String orderAttribute = element.getAttribute("order");
        int order = orderAttribute.isEmpty() ? 1 : Integer.valueOf(orderAttribute);
        RootBeanDefinition handlerMappingDef = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
        handlerMappingDef.setSource(source);
        handlerMappingDef.setRole(2);
        handlerMappingDef.getPropertyValues().add("order", (Object)order);
        String handlerMappingName = context.getReaderContext().registerWithGeneratedName((BeanDefinition)handlerMappingDef);
        RuntimeBeanReference sockJsService = WebSocketNamespaceUtils.registerSockJsService(element, SOCK_JS_SCHEDULER_NAME, context, source);
        if (sockJsService != null) {
            strategy = new SockJsHandlerMappingStrategy(sockJsService);
        } else {
            RuntimeBeanReference handshakeHandler = WebSocketNamespaceUtils.registerHandshakeHandler(element, context, source);
            Element interceptorsElement = DomUtils.getChildElementByTagName((Element)element, (String)"handshake-interceptors");
            ManagedList<? super Object> interceptors = WebSocketNamespaceUtils.parseBeanSubElements(interceptorsElement, context);
            String allowedOriginsAttribute = element.getAttribute("allowed-origins");
            List<String> allowedOrigins = Arrays.asList(StringUtils.tokenizeToStringArray((String)allowedOriginsAttribute, (String)","));
            interceptors.add((Object)new OriginHandshakeInterceptor(allowedOrigins));
            strategy = new WebSocketHandlerMappingStrategy(handshakeHandler, interceptors);
        }
        ManagedMap urlMap = new ManagedMap();
        urlMap.setSource(source);
        for (Element mappingElement : DomUtils.getChildElementsByTagName((Element)element, (String)"mapping")) {
            strategy.addMapping(mappingElement, (ManagedMap<String, Object>)urlMap, context);
        }
        handlerMappingDef.getPropertyValues().add("urlMap", (Object)urlMap);
        context.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerMappingDef, handlerMappingName));
        context.popAndRegisterContainingComponent();
        return null;
    }

    private static class SockJsHandlerMappingStrategy
    implements HandlerMappingStrategy {
        private final RuntimeBeanReference sockJsService;

        private SockJsHandlerMappingStrategy(RuntimeBeanReference sockJsService) {
            this.sockJsService = sockJsService;
        }

        @Override
        public void addMapping(Element element, ManagedMap<String, Object> urlMap, ParserContext context) {
            String pathAttribute = element.getAttribute("path");
            List<String> mappings = Arrays.asList(StringUtils.tokenizeToStringArray((String)pathAttribute, (String)","));
            RuntimeBeanReference handlerReference = new RuntimeBeanReference(element.getAttribute("handler"));
            ConstructorArgumentValues cavs = new ConstructorArgumentValues();
            cavs.addIndexedArgumentValue(0, (Object)this.sockJsService, "SockJsService");
            cavs.addIndexedArgumentValue(1, (Object)handlerReference, "WebSocketHandler");
            RootBeanDefinition requestHandlerDef = new RootBeanDefinition(SockJsHttpRequestHandler.class, cavs, null);
            requestHandlerDef.setSource(context.extractSource((Object)element));
            requestHandlerDef.setRole(2);
            String requestHandlerName = context.getReaderContext().registerWithGeneratedName((BeanDefinition)requestHandlerDef);
            RuntimeBeanReference requestHandlerRef = new RuntimeBeanReference(requestHandlerName);
            for (String mapping : mappings) {
                String pathPattern = mapping.endsWith("/") ? mapping + "**" : mapping + "/**";
                urlMap.put((Object)pathPattern, (Object)requestHandlerRef);
            }
        }
    }

    private static class WebSocketHandlerMappingStrategy
    implements HandlerMappingStrategy {
        private final RuntimeBeanReference handshakeHandlerReference;
        private final ManagedList<?> interceptorsList;

        private WebSocketHandlerMappingStrategy(RuntimeBeanReference handshakeHandler, ManagedList<?> interceptors) {
            this.handshakeHandlerReference = handshakeHandler;
            this.interceptorsList = interceptors;
        }

        @Override
        public void addMapping(Element element, ManagedMap<String, Object> urlMap, ParserContext context) {
            String pathAttribute = element.getAttribute("path");
            List<String> mappings = Arrays.asList(StringUtils.tokenizeToStringArray((String)pathAttribute, (String)","));
            RuntimeBeanReference handlerReference = new RuntimeBeanReference(element.getAttribute("handler"));
            ConstructorArgumentValues cavs = new ConstructorArgumentValues();
            cavs.addIndexedArgumentValue(0, (Object)handlerReference);
            if (this.handshakeHandlerReference != null) {
                cavs.addIndexedArgumentValue(1, (Object)this.handshakeHandlerReference);
            }
            RootBeanDefinition requestHandlerDef = new RootBeanDefinition(WebSocketHttpRequestHandler.class, cavs, null);
            requestHandlerDef.setSource(context.extractSource((Object)element));
            requestHandlerDef.setRole(2);
            requestHandlerDef.getPropertyValues().add("handshakeInterceptors", this.interceptorsList);
            String requestHandlerName = context.getReaderContext().registerWithGeneratedName((BeanDefinition)requestHandlerDef);
            RuntimeBeanReference requestHandlerRef = new RuntimeBeanReference(requestHandlerName);
            for (String mapping : mappings) {
                urlMap.put((Object)mapping, (Object)requestHandlerRef);
            }
        }
    }

    private static interface HandlerMappingStrategy {
        public void addMapping(Element var1, ManagedMap<String, Object> var2, ParserContext var3);
    }
}

