/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.handler;

import java.util.Map;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.sockjs.SockJsException;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;
import org.springframework.web.socket.sockjs.transport.SockJsSession;
import org.springframework.web.socket.sockjs.transport.SockJsSessionFactory;
import org.springframework.web.socket.sockjs.transport.TransportType;
import org.springframework.web.socket.sockjs.transport.handler.AbstractTransportHandler;
import org.springframework.web.socket.sockjs.transport.handler.SockJsWebSocketHandler;
import org.springframework.web.socket.sockjs.transport.session.AbstractSockJsSession;
import org.springframework.web.socket.sockjs.transport.session.WebSocketServerSockJsSession;

public class WebSocketTransportHandler
extends AbstractTransportHandler
implements SockJsSessionFactory,
HandshakeHandler {
    private final HandshakeHandler handshakeHandler;

    public WebSocketTransportHandler(HandshakeHandler handshakeHandler) {
        Assert.notNull((Object)handshakeHandler, (String)"handshakeHandler must not be null");
        this.handshakeHandler = handshakeHandler;
    }

    @Override
    public TransportType getTransportType() {
        return TransportType.WEBSOCKET;
    }

    public HandshakeHandler getHandshakeHandler() {
        return this.handshakeHandler;
    }

    @Override
    public AbstractSockJsSession createSession(String id, WebSocketHandler handler, Map<String, Object> attrs) {
        return new WebSocketServerSockJsSession(id, this.getServiceConfig(), handler, attrs);
    }

    @Override
    public void handleRequest(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, SockJsSession wsSession) throws SockJsException {
        WebSocketServerSockJsSession sockJsSession = (WebSocketServerSockJsSession)wsSession;
        try {
            wsHandler = new SockJsWebSocketHandler(this.getServiceConfig(), wsHandler, sockJsSession);
            this.handshakeHandler.doHandshake(request, response, wsHandler, sockJsSession.getAttributes());
        }
        catch (Throwable ex) {
            sockJsSession.tryCloseWithSockJsTransportError(ex, CloseStatus.SERVER_ERROR);
            throw new SockJsTransportFailureException("WebSocket handshake failure", wsSession.getId(), ex);
        }
    }

    @Override
    public boolean doHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler handler, Map<String, Object> attributes) throws HandshakeFailureException {
        return this.handshakeHandler.doHandshake(request, response, handler, attributes);
    }
}

