/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client.jetty;

import java.net.URI;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.springframework.context.Lifecycle;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureTask;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.jetty.JettyWebSocketHandlerAdapter;
import org.springframework.web.socket.adapter.jetty.JettyWebSocketSession;
import org.springframework.web.socket.adapter.jetty.WebSocketToJettyExtensionConfigAdapter;
import org.springframework.web.socket.client.AbstractWebSocketClient;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class JettyWebSocketClient
extends AbstractWebSocketClient
implements Lifecycle {
    private final WebSocketClient client;
    @Nullable
    private AsyncListenableTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();

    public JettyWebSocketClient() {
        this.client = new WebSocketClient();
    }

    public JettyWebSocketClient(WebSocketClient client) {
        this.client = client;
    }

    public void setTaskExecutor(@Nullable AsyncListenableTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Nullable
    public AsyncListenableTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void start() {
        try {
            this.client.start();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to start Jetty WebSocketClient", ex);
        }
    }

    public void stop() {
        try {
            this.client.stop();
        }
        catch (Exception ex) {
            this.logger.error((Object)"Failed to stop Jetty WebSocketClient", (Throwable)ex);
        }
    }

    public boolean isRunning() {
        return this.client.isStarted();
    }

    @Override
    public ListenableFuture<WebSocketSession> doHandshake(WebSocketHandler webSocketHandler, String uriTemplate, Object ... uriVars) {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)uriTemplate).buildAndExpand(uriVars).encode();
        return this.doHandshake(webSocketHandler, null, uriComponents.toUri());
    }

    @Override
    public ListenableFuture<WebSocketSession> doHandshakeInternal(WebSocketHandler wsHandler, HttpHeaders headers, URI uri, List<String> protocols, List<WebSocketExtension> extensions, Map<String, Object> attributes) {
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setSubProtocols(protocols);
        for (WebSocketExtension e : extensions) {
            request.addExtensions(new ExtensionConfig[]{new WebSocketToJettyExtensionConfigAdapter(e)});
        }
        headers.forEach((arg_0, arg_1) -> ((ClientUpgradeRequest)request).setHeader(arg_0, arg_1));
        Principal user = this.getUser();
        JettyWebSocketSession wsSession = new JettyWebSocketSession(attributes, user);
        JettyWebSocketHandlerAdapter listener = new JettyWebSocketHandlerAdapter(wsHandler, wsSession);
        Callable<WebSocketSession> connectTask = () -> {
            Future future = this.client.connect((Object)listener, uri, request);
            future.get();
            return wsSession;
        };
        if (this.taskExecutor != null) {
            return this.taskExecutor.submitListenable(connectTask);
        }
        ListenableFutureTask task = new ListenableFutureTask(connectTask);
        task.run();
        return task;
    }

    @Nullable
    protected Principal getUser() {
        return null;
    }
}

