/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class ServletRequestDataBinder
extends WebDataBinder {
    private boolean bindEmptyMultipartFiles = true;

    public ServletRequestDataBinder(Object target, String objectName) {
        super(target, objectName);
    }

    public void setBindEmptyMultipartFiles(boolean bindEmptyMultipartFiles) {
        this.bindEmptyMultipartFiles = bindEmptyMultipartFiles;
    }

    public boolean isBindEmptyMultipartFiles() {
        return this.bindEmptyMultipartFiles;
    }

    public void bind(ServletRequest request) {
        ServletRequestParameterPropertyValues mpvs = new ServletRequestParameterPropertyValues(request);
        this.checkMultipartFiles(request, mpvs);
        this.doBind(mpvs);
    }

    protected void checkMultipartFiles(ServletRequest request, MutablePropertyValues mpvs) {
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            Iterator it = fileMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                MultipartFile value = (MultipartFile)entry.getValue();
                if (!this.isBindEmptyMultipartFiles() && value.isEmpty()) continue;
                mpvs.addPropertyValue(key, value);
            }
        }
    }

    public void closeNoCatch() throws ServletRequestBindingException {
        if (this.getErrors().hasErrors()) {
            throw new ServletRequestBindingException("Errors binding onto object '" + this.getErrors().getObjectName() + "'", this.getErrors());
        }
    }
}

