/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.SqlRowSetResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.util.Assert;

public class NamedParameterJdbcTemplate
implements NamedParameterJdbcOperations {
    private final JdbcOperations classicJdbcTemplate;
    static /* synthetic */ Class class$java$lang$Number;

    public NamedParameterJdbcTemplate(DataSource dataSource) {
        Assert.notNull(dataSource, "The [dataSource] argument cannot be null.");
        this.classicJdbcTemplate = new JdbcTemplate(dataSource);
    }

    public NamedParameterJdbcTemplate(JdbcOperations classicJdbcTemplate) {
        Assert.notNull(classicJdbcTemplate, "The [classicJdbcTemplate] argument cannot be null.");
        this.classicJdbcTemplate = classicJdbcTemplate;
    }

    public JdbcOperations getJdbcOperations() {
        return this.classicJdbcTemplate;
    }

    public void query(String sql, SqlParameterSource paramSource, RowCallbackHandler rch) throws DataAccessException {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        Object[] args = NamedParameterUtils.buildValueArray(parsedSql, paramSource);
        int[] argTypes = NamedParameterUtils.buildSqlTypeArray(parsedSql, paramSource);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(sql, paramSource);
        this.getJdbcOperations().query(sqlToUse, args, argTypes, rch);
    }

    public void query(String sql, Map paramMap, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), rch);
    }

    public List query(String sql, SqlParameterSource paramSource, RowMapper rowMapper) throws DataAccessException {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        Object[] args = NamedParameterUtils.buildValueArray(parsedSql, paramSource);
        int[] argTypes = NamedParameterUtils.buildSqlTypeArray(parsedSql, paramSource);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(sql, paramSource);
        return (List)this.getJdbcOperations().query(sqlToUse, args, argTypes, new RowMapperResultSetExtractor(rowMapper));
    }

    public List query(String sql, Map paramMap, RowMapper rowMapper) throws DataAccessException {
        return this.query(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), rowMapper);
    }

    public Object queryForObject(String sql, SqlParameterSource paramSource, RowMapper rowMapper) throws DataAccessException {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        Object[] args = NamedParameterUtils.buildValueArray(parsedSql, paramSource);
        int[] argTypes = NamedParameterUtils.buildSqlTypeArray(parsedSql, paramSource);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(sql, paramSource);
        List results = (List)this.getJdbcOperations().query(sqlToUse, args, argTypes, new RowMapperResultSetExtractor(rowMapper, 1));
        return DataAccessUtils.requiredSingleResult(results);
    }

    public Object queryForObject(String sql, Map paramMap, RowMapper rowMapper) throws DataAccessException {
        return this.queryForObject(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), rowMapper);
    }

    public Object queryForObject(String sql, SqlParameterSource paramSource, Class requiredType) throws DataAccessException {
        return this.queryForObject(sql, paramSource, (RowMapper)new SingleColumnRowMapper(requiredType));
    }

    public Object queryForObject(String sql, Map paramMap, Class requiredType) throws DataAccessException {
        return this.queryForObject(sql, paramMap, (RowMapper)new SingleColumnRowMapper(requiredType));
    }

    public Map queryForMap(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return (Map)this.queryForObject(sql, paramSource, (RowMapper)new ColumnMapRowMapper());
    }

    public Map queryForMap(String sql, Map paramMap) throws DataAccessException {
        return (Map)this.queryForObject(sql, paramMap, (RowMapper)new ColumnMapRowMapper());
    }

    public long queryForLong(String sql, SqlParameterSource paramSource) throws DataAccessException {
        Number number = (Number)this.queryForObject(sql, paramSource, class$java$lang$Number == null ? (class$java$lang$Number = NamedParameterJdbcTemplate.class$("java.lang.Number")) : class$java$lang$Number);
        return number != null ? number.longValue() : 0L;
    }

    public long queryForLong(String sql, Map paramMap) throws DataAccessException {
        return this.queryForLong(sql, new MapSqlParameterSource(paramMap));
    }

    public int queryForInt(String sql, SqlParameterSource paramSource) throws DataAccessException {
        Number number = (Number)this.queryForObject(sql, paramSource, class$java$lang$Number == null ? (class$java$lang$Number = NamedParameterJdbcTemplate.class$("java.lang.Number")) : class$java$lang$Number);
        return number != null ? number.intValue() : 0;
    }

    public int queryForInt(String sql, Map paramMap) throws DataAccessException {
        return this.queryForInt(sql, new MapSqlParameterSource(paramMap));
    }

    public List queryForList(String sql, SqlParameterSource paramSource, Class elementType) throws DataAccessException {
        return this.query(sql, paramSource, (RowMapper)new SingleColumnRowMapper(elementType));
    }

    public List queryForList(String sql, Map paramMap, Class elementType) throws DataAccessException {
        return this.queryForList(sql, new MapSqlParameterSource(paramMap), elementType);
    }

    public List queryForList(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return this.query(sql, paramSource, (RowMapper)new ColumnMapRowMapper());
    }

    public List queryForList(String sql, Map paramMap) throws DataAccessException {
        return this.queryForList(sql, new MapSqlParameterSource(paramMap));
    }

    public SqlRowSet queryForRowSet(String sql, SqlParameterSource paramSource) throws DataAccessException {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        Object[] args = NamedParameterUtils.buildValueArray(parsedSql, paramSource);
        int[] argTypes = NamedParameterUtils.buildSqlTypeArray(parsedSql, paramSource);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(sql, paramSource);
        return (SqlRowSet)this.getJdbcOperations().query(sqlToUse, args, argTypes, new SqlRowSetResultSetExtractor());
    }

    public SqlRowSet queryForRowSet(String sql, Map paramMap) throws DataAccessException {
        return this.queryForRowSet(sql, new MapSqlParameterSource(paramMap));
    }

    public int update(String sql, SqlParameterSource paramSource) throws DataAccessException {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        Object[] args = NamedParameterUtils.buildValueArray(parsedSql, paramSource);
        int[] argTypes = NamedParameterUtils.buildSqlTypeArray(parsedSql, paramSource);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(sql, paramSource);
        return this.getJdbcOperations().update(sqlToUse, args, argTypes);
    }

    public int update(String sql, Map paramMap) throws DataAccessException {
        return this.update(sql, new MapSqlParameterSource(paramMap));
    }

    public int update(String sql, SqlParameterSource paramSource, KeyHolder generatedKeyHolder) throws DataAccessException {
        return this.update(sql, paramSource, generatedKeyHolder, null);
    }

    public int update(String sql, SqlParameterSource paramSource, KeyHolder generatedKeyHolder, String[] keyColumnNames) throws DataAccessException {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        Object[] args = NamedParameterUtils.buildValueArray(parsedSql, paramSource);
        int[] argTypes = NamedParameterUtils.buildSqlTypeArray(parsedSql, paramSource);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(sql, paramSource);
        PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sqlToUse, argTypes);
        if (keyColumnNames != null) {
            pscf.setGeneratedKeysColumnNames(keyColumnNames);
        } else {
            pscf.setReturnGeneratedKeys(true);
        }
        return this.getJdbcOperations().update(pscf.newPreparedStatementCreator(args), generatedKeyHolder);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

