/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.util.Assert;

public class SimpleMessageListenerContainer
extends AbstractMessageListenerContainer {
    private boolean pubSubNoLocal = false;
    private int concurrentConsumers = 1;
    private TaskExecutor taskExecutor;
    private Set sessions;
    private Set consumers;

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    protected boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        Assert.isTrue(concurrentConsumers > 0, "'concurrentConsumers' value must be at least 1 (one)");
        this.concurrentConsumers = concurrentConsumers;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected void validateConfiguration() {
        super.validateConfiguration();
        if (this.isSubscriptionDurable() && this.concurrentConsumers != 1) {
            throw new IllegalArgumentException("Only 1 concurrent consumer supported for durable subscription");
        }
    }

    protected final boolean sharedConnectionEnabled() {
        return true;
    }

    protected void doInitialize() throws JMSException {
        this.sessions = new HashSet(this.concurrentConsumers);
        this.consumers = new HashSet(this.concurrentConsumers);
        for (int i = 0; i < this.concurrentConsumers; ++i) {
            Session session = this.createSession(this.getSharedConnection());
            MessageConsumer consumer = this.createListenerConsumer(session);
            this.sessions.add(session);
            this.consumers.add(consumer);
        }
    }

    protected MessageConsumer createListenerConsumer(final Session session) throws JMSException {
        Destination destination = this.getDestination();
        if (destination == null) {
            destination = this.resolveDestinationName(session, this.getDestinationName());
        }
        MessageConsumer consumer = this.createConsumer(session, destination);
        if (this.taskExecutor != null) {
            consumer.setMessageListener(new MessageListener(){

                public void onMessage(final Message message) {
                    SimpleMessageListenerContainer.this.taskExecutor.execute(new Runnable(){

                        public void run() {
                            SimpleMessageListenerContainer.this.executeListener(session, message);
                        }
                    });
                }
            });
        } else {
            consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    SimpleMessageListenerContainer.this.executeListener(session, message);
                }
            });
        }
        return consumer;
    }

    protected void doShutdown() throws JMSException {
        this.logger.debug((Object)"Closing JMS MessageConsumers");
        Iterator it = this.consumers.iterator();
        while (it.hasNext()) {
            MessageConsumer consumer = (MessageConsumer)it.next();
            JmsUtils.closeMessageConsumer(consumer);
        }
        this.logger.debug((Object)"Closing JMS Sessions");
        it = this.sessions.iterator();
        while (it.hasNext()) {
            Session session = (Session)it.next();
            JmsUtils.closeSession(session);
        }
    }

    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (this.isPubSubDomain()) {
            if (this.isSubscriptionDurable() && destination instanceof Topic) {
                return session.createDurableSubscriber((Topic)destination, this.getDurableSubscriptionName(), this.getMessageSelector(), this.isPubSubNoLocal());
            }
            return session.createConsumer(destination, this.getMessageSelector(), this.isPubSubNoLocal());
        }
        return session.createConsumer(destination, this.getMessageSelector());
    }
}

