/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.util.Collection;
import javax.servlet.jsp.JspException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagIdGenerator;
import org.springframework.web.servlet.tags.form.TagWriter;

public class CheckboxTag
extends AbstractHtmlInputElementTag {
    private Object value;
    static /* synthetic */ Class class$java$lang$Boolean;

    public void setValue(Object value) {
        Assert.notNull(value, "'value' must not be null");
        this.value = value;
    }

    protected Object getValue() {
        return this.value;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("input");
        this.writeDefaultAttributes(tagWriter);
        tagWriter.writeAttribute("type", "checkbox");
        Object boundValue = this.getBoundValue();
        Class valueType = this.getBindStatus().getValueType();
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = CheckboxTag.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(valueType) || Boolean.TYPE.equals(valueType)) {
            if (boundValue instanceof String) {
                boundValue = Boolean.valueOf((String)boundValue);
            }
            Boolean booleanValue = boundValue != null ? (Boolean)boundValue : Boolean.FALSE;
            this.renderFromBoolean(booleanValue, tagWriter);
        } else {
            Object resolvedValue;
            Object value = this.getValue();
            if (value == null) {
                throw new IllegalArgumentException("Attribute 'value' is required when binding to non-boolean values");
            }
            Object object = resolvedValue = value instanceof String ? this.evaluate("value", (String)value) : value;
            if (boundValue != null && boundValue.getClass().isArray()) {
                this.renderFromCollection(resolvedValue, CollectionUtils.arrayToList(boundValue), tagWriter);
            } else if (boundValue instanceof Collection) {
                this.renderFromCollection(resolvedValue, (Collection)boundValue, tagWriter);
            } else {
                this.renderSingleValue(resolvedValue, tagWriter);
            }
        }
        tagWriter.endTag();
        if (!this.isDisabled()) {
            tagWriter.startTag("input");
            tagWriter.writeAttribute("type", "hidden");
            tagWriter.writeAttribute("value", "1");
            tagWriter.writeAttribute("name", "_" + this.getName());
            tagWriter.endTag();
        }
        return 6;
    }

    private void renderSingleValue(Object resolvedValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", this.getDisplayString(resolvedValue));
        if (SelectedValueComparator.isSelected(this.getBindStatus(), resolvedValue)) {
            tagWriter.writeAttribute("checked", "checked");
        }
    }

    private void renderFromCollection(Object resolvedValue, Collection boundValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", this.getDisplayString(resolvedValue));
        if (SelectedValueComparator.isSelected(this.getBindStatus(), resolvedValue)) {
            tagWriter.writeAttribute("checked", "checked");
        }
    }

    private void renderFromBoolean(Boolean boundValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", "true");
        if (boundValue.booleanValue()) {
            tagWriter.writeAttribute("checked", "checked");
        }
    }

    protected String autogenerateId() throws JspException {
        return TagIdGenerator.nextId(this.getName(), this.pageContext);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

