/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.service.CollectionFormat;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483648)
public class ParameterMultiplesReader
implements ParameterBuilderPlugin {
    public void apply(ParameterContext context) {
        ResolvedType parameterType = context.resolvedMethodParameter().getParameterType();
        context.parameterBuilder().allowMultiple(this.isCollectionType(parameterType));
        context.requestParameterBuilder().query(q -> q.collectionFormat((CollectionFormat)(this.isCollectionType(parameterType) ? CollectionFormat.MULTI : null)));
    }

    private boolean isCollectionType(ResolvedType parameterType) {
        return Collections.isContainerType((ResolvedType)parameterType) || Iterable.class.isAssignableFrom(parameterType.getErasedType());
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

