/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.adapter.jul;

import java.util.logging.Logger;
import org.tinylog.Level;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.ContextProvider;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.NopContextProvider;
import org.tinylog.runtime.RuntimeProvider;

public final class JavaUtilLoggingProvider
implements LoggingProvider {
    private ContextProvider contextProvider = new NopContextProvider();

    public ContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public Level getMinimumLevel() {
        return Level.TRACE;
    }

    public Level getMinimumLevel(String tag) {
        return Level.TRACE;
    }

    public boolean isEnabled(int depth, String tag, Level level) {
        String callerClassName = RuntimeProvider.getCallerClassName((int)(depth + 1));
        return Logger.getLogger(callerClassName).isLoggable(JavaUtilLoggingProvider.translate(level));
    }

    public void log(int depth, String tag, Level level, Throwable exception, MessageFormatter formatter, Object obj, Object ... arguments) {
        java.util.logging.Level julLevel;
        StackTraceElement caller = RuntimeProvider.getCallerStackTraceElement((int)(depth + 1));
        Logger julLogger = Logger.getLogger(caller.getClassName());
        if (julLogger.isLoggable(julLevel = JavaUtilLoggingProvider.translate(level))) {
            String message = String.valueOf(obj);
            if (arguments != null && arguments.length > 0) {
                message = formatter.format(message, arguments);
            }
            julLogger.logp(julLevel, caller.getClassName(), caller.getMethodName(), message, exception);
        }
    }

    public void log(String loggerClassName, String tag, Level level, Throwable exception, MessageFormatter formatter, Object obj, Object ... arguments) {
        java.util.logging.Level julLevel;
        StackTraceElement caller = RuntimeProvider.getCallerStackTraceElement((String)loggerClassName);
        Logger julLogger = Logger.getLogger(caller.getClassName());
        if (julLogger.isLoggable(julLevel = JavaUtilLoggingProvider.translate(level))) {
            String message = String.valueOf(obj);
            if (arguments != null && arguments.length > 0) {
                message = formatter.format(message, arguments);
            }
            julLogger.logp(julLevel, caller.getClassName(), caller.getMethodName(), message, exception);
        }
    }

    public void shutdown() {
    }

    private static java.util.logging.Level translate(Level level) {
        switch (level) {
            case TRACE: {
                return java.util.logging.Level.FINER;
            }
            case DEBUG: {
                return java.util.logging.Level.FINE;
            }
            case INFO: {
                return java.util.logging.Level.INFO;
            }
            case WARN: {
                return java.util.logging.Level.WARNING;
            }
            case ERROR: {
                return java.util.logging.Level.SEVERE;
            }
        }
        return java.util.logging.Level.OFF;
    }
}

