/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.WebappServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.tomcat.internal.DataHolder;

public class SCIRegistrarContextConfig
extends ContextConfig {
    private static Log log = LogFactory.getLog(SCIRegistrarContextConfig.class);

    protected void processServletContainerInitializers() {
        List detectedScis;
        try {
            WebappServiceLoader loader = new WebappServiceLoader(this.context);
            detectedScis = loader.load(ServletContainerInitializer.class);
        }
        catch (IOException e) {
            log.error((Object)sm.getString("contextConfig.servletContainerInitializerFail", new Object[]{this.context.getName()}), (Throwable)e);
            this.ok = false;
            return;
        }
        List<ServletContainerInitializer> mutableDetectedScis = this.getCustomSciList(detectedScis);
        for (ServletContainerInitializer sci : mutableDetectedScis) {
            Class[] types;
            HandlesTypes ht;
            this.initializerClassMap.put(sci, new HashSet());
            try {
                ht = sci.getClass().getAnnotation(HandlesTypes.class);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("contextConfig.sci.debug", new Object[]{sci.getClass().getName()}), (Throwable)e);
                    continue;
                }
                log.info((Object)sm.getString("contextConfig.sci.info", new Object[]{sci.getClass().getName()}));
                continue;
            }
            if (ht == null || (types = ht.value()) == null) continue;
            for (Class type : types) {
                if (type.isAnnotation()) {
                    this.handlesTypesAnnotations = true;
                } else {
                    this.handlesTypesNonAnnotations = true;
                }
                HashSet<ServletContainerInitializer> scis = (HashSet<ServletContainerInitializer>)this.typeInitializerMap.get(type);
                if (scis == null) {
                    scis = new HashSet<ServletContainerInitializer>();
                    this.typeInitializerMap.put(type, scis);
                }
                scis.add(sci);
            }
        }
    }

    private List<ServletContainerInitializer> getCustomSciList(List<ServletContainerInitializer> detectedScis) {
        ArrayList<ServletContainerInitializer> mutableDetectedScis = new ArrayList<ServletContainerInitializer>();
        mutableDetectedScis.addAll(detectedScis);
        List<ServletContainerInitializer> sciList = DataHolder.getInstance().getServiceContainerInitializers();
        mutableDetectedScis.addAll(sciList);
        return mutableDetectedScis;
    }
}

