/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.zeromq.ZMQ;

public class EmbeddedLibraryTools {
    public static final boolean LOADED_EMBEDDED_LIBRARY = EmbeddedLibraryTools.loadEmbeddedLibrary();

    public static String getCurrentPlatformIdentifier() {
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            osName = "Windows";
        }
        return System.getProperty("os.arch") + "/" + osName;
    }

    public static Collection<String> getEmbeddedLibraryList() {
        ArrayList<String> result = new ArrayList<String>();
        Collection<String> files = EmbeddedLibraryTools.catalogClasspath();
        for (String file : files) {
            if (!file.startsWith("NATIVE")) continue;
            result.add(file);
        }
        return result;
    }

    private static void catalogArchive(File jarfile, Collection<String> files) {
        try {
            JarFile j = new JarFile(jarfile);
            Enumeration<JarEntry> e = j.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (entry.isDirectory()) continue;
                files.add(entry.getName());
            }
        }
        catch (IOException x) {
            System.err.println(x.toString());
        }
    }

    private static Collection<String> catalogClasspath() {
        String[] classpath;
        ArrayList<String> files = new ArrayList<String>();
        for (String path : classpath = System.getProperty("java.class.path", "").split(File.pathSeparator)) {
            File tmp = new File(path);
            if (tmp.isFile() && path.toLowerCase().endsWith(".jar")) {
                EmbeddedLibraryTools.catalogArchive(tmp, files);
                continue;
            }
            if (!tmp.isDirectory()) continue;
            int len = tmp.getPath().length() + 1;
            EmbeddedLibraryTools.catalogFiles(len, tmp, files);
        }
        return files;
    }

    private static void catalogFiles(int prefixlen, File root, Collection<String> files) {
        File[] ff;
        for (File f : ff = root.listFiles()) {
            if (f.isDirectory()) {
                EmbeddedLibraryTools.catalogFiles(prefixlen, f, files);
                continue;
            }
            files.add(f.getPath().substring(prefixlen));
        }
    }

    private static boolean loadEmbeddedLibrary() {
        boolean usingEmbedded = false;
        String[] allowedExtensions = new String[]{"so", "dylib", "dll"};
        StringBuilder url = new StringBuilder();
        url.append("/NATIVE/");
        url.append(EmbeddedLibraryTools.getCurrentPlatformIdentifier());
        url.append("/libjzmq.");
        URL nativeLibraryUrl = null;
        for (String ext : allowedExtensions) {
            nativeLibraryUrl = ZMQ.class.getResource(url.toString() + ext);
            if (nativeLibraryUrl != null) break;
        }
        if (nativeLibraryUrl != null) {
            try {
                File libfile = File.createTempFile("libjzmq-", ".lib");
                libfile.deleteOnExit();
                InputStream in = nativeLibraryUrl.openStream();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(libfile));
                int len = 0;
                byte[] buffer = new byte[8192];
                while ((len = in.read(buffer)) > -1) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
                System.load(libfile.getAbsolutePath());
                libfile.delete();
                usingEmbedded = true;
            }
            catch (IOException x) {
                // empty catch block
            }
        }
        return usingEmbedded;
    }

    private EmbeddedLibraryTools() {
    }
}

