/*
 * Decompiled with CFR 0.152.
 */
package pub.devrel.easypermissions;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import pub.devrel.easypermissions.AfterPermissionGranted;
import pub.devrel.easypermissions.RationaleDialogFragment;
import pub.devrel.easypermissions.RationaleDialogFragmentCompat;

public class EasyPermissions {
    private static final String TAG = "EasyPermissions";
    private static final String DIALOG_TAG = "RationaleDialogFragmentCompat";

    public static boolean hasPermissions(@NonNull Context context, String ... perms) {
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)TAG, (String)"hasPermissions: API version < M, returning true by default");
            return true;
        }
        for (String perm : perms) {
            boolean hasPerm;
            boolean bl = hasPerm = ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0;
            if (hasPerm) continue;
            return false;
        }
        return true;
    }

    public static void requestPermissions(@NonNull Activity activity, @NonNull String rationale, int requestCode, String ... perms) {
        EasyPermissions.requestPermissions(activity, rationale, 17039370, 0x1040000, requestCode, perms);
    }

    @SuppressLint(value={"NewApi"})
    public static void requestPermissions(@NonNull Activity activity, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        if (EasyPermissions.hasPermissions((Context)activity, perms)) {
            EasyPermissions.notifyAlreadyHasPermissions(activity, requestCode, perms);
            return;
        }
        if (EasyPermissions.shouldShowRationale(activity, perms)) {
            EasyPermissions.showRationaleDialogFragment(activity.getFragmentManager(), rationale, positiveButton, negativeButton, requestCode, perms);
        } else {
            ActivityCompat.requestPermissions((Activity)activity, (String[])perms, (int)requestCode);
        }
    }

    public static void requestPermissions(@NonNull android.support.v4.app.Fragment fragment, @NonNull String rationale, int requestCode, String ... perms) {
        EasyPermissions.requestPermissions(fragment, rationale, 17039370, 0x1040000, requestCode, perms);
    }

    @SuppressLint(value={"NewApi"})
    public static void requestPermissions(@NonNull android.support.v4.app.Fragment fragment, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        if (EasyPermissions.hasPermissions(fragment.getContext(), perms)) {
            EasyPermissions.notifyAlreadyHasPermissions(fragment, requestCode, perms);
            return;
        }
        if (EasyPermissions.shouldShowRationale(fragment, perms)) {
            RationaleDialogFragmentCompat.newInstance(positiveButton, negativeButton, rationale, requestCode, perms).show(fragment.getChildFragmentManager(), DIALOG_TAG);
        } else {
            fragment.requestPermissions(perms, requestCode);
        }
    }

    @RequiresApi(api=11)
    public static void requestPermissions(@NonNull Fragment fragment, @NonNull String rationale, int requestCode, String ... perms) {
        EasyPermissions.requestPermissions(fragment, rationale, 17039370, 0x1040000, requestCode, perms);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(api=11)
    public static void requestPermissions(@NonNull Fragment fragment, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        if (EasyPermissions.hasPermissions((Context)fragment.getActivity(), perms)) {
            EasyPermissions.notifyAlreadyHasPermissions(fragment, requestCode, perms);
            return;
        }
        if (EasyPermissions.shouldShowRationale(fragment, perms)) {
            EasyPermissions.showRationaleDialogFragment(fragment.getChildFragmentManager(), rationale, positiveButton, negativeButton, requestCode, perms);
        } else {
            fragment.requestPermissions(perms, requestCode);
        }
    }

    public static void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults, Object ... receivers) {
        ArrayList<String> granted = new ArrayList<String>();
        ArrayList<String> denied = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            String perm = permissions[i];
            if (grantResults[i] == 0) {
                granted.add(perm);
                continue;
            }
            denied.add(perm);
        }
        for (Object object : receivers) {
            if (!granted.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsGranted(requestCode, granted);
            }
            if (!denied.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsDenied(requestCode, denied);
            }
            if (granted.isEmpty() || !denied.isEmpty()) continue;
            EasyPermissions.runAnnotatedMethods(object, requestCode);
        }
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull Activity activity, @NonNull List<String> deniedPermissions) {
        for (String deniedPermission : deniedPermissions) {
            if (!EasyPermissions.permissionPermanentlyDenied(activity, deniedPermission)) continue;
            return true;
        }
        return false;
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull android.support.v4.app.Fragment fragment, @NonNull List<String> deniedPermissions) {
        for (String deniedPermission : deniedPermissions) {
            if (!EasyPermissions.permissionPermanentlyDenied(fragment, deniedPermission)) continue;
            return true;
        }
        return false;
    }

    @RequiresApi(api=23)
    public static boolean somePermissionPermanentlyDenied(@NonNull Fragment fragment, @NonNull List<String> deniedPermissions) {
        for (String deniedPermission : deniedPermissions) {
            if (!EasyPermissions.permissionPermanentlyDenied(fragment, deniedPermission)) continue;
            return true;
        }
        return false;
    }

    public static boolean permissionPermanentlyDenied(@NonNull Activity activity, @NonNull String deniedPermission) {
        return !EasyPermissions.shouldShowRequestPermissionRationale(activity, deniedPermission);
    }

    public static boolean permissionPermanentlyDenied(@NonNull android.support.v4.app.Fragment fragment, @NonNull String deniedPermission) {
        return !EasyPermissions.shouldShowRequestPermissionRationale(fragment, deniedPermission);
    }

    @RequiresApi(api=23)
    public static boolean permissionPermanentlyDenied(@NonNull Fragment fragment, @NonNull String deniedPermission) {
        return !EasyPermissions.shouldShowRequestPermissionRationale(fragment, deniedPermission);
    }

    private static void notifyAlreadyHasPermissions(Object object, int requestCode, @NonNull String[] perms) {
        int[] grantResults = new int[perms.length];
        for (int i = 0; i < perms.length; ++i) {
            grantResults[i] = 0;
        }
        EasyPermissions.onRequestPermissionsResult(requestCode, perms, grantResults, object);
    }

    private static boolean shouldShowRationale(@NonNull Object object, @NonNull String[] perms) {
        boolean shouldShowRationale = false;
        for (String perm : perms) {
            shouldShowRationale = shouldShowRationale || EasyPermissions.shouldShowRequestPermissionRationale(object, perm);
        }
        return shouldShowRationale;
    }

    private static boolean shouldShowRequestPermissionRationale(@NonNull Object object, @NonNull String perm) {
        if (object instanceof Activity) {
            return ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)object), (String)perm);
        }
        if (object instanceof android.support.v4.app.Fragment) {
            return ((android.support.v4.app.Fragment)object).shouldShowRequestPermissionRationale(perm);
        }
        if (object instanceof Fragment) {
            if (Build.VERSION.SDK_INT >= 23) {
                return ((Fragment)object).shouldShowRequestPermissionRationale(perm);
            }
            throw new IllegalArgumentException("Target SDK needs to be greater than 23 if caller is android.app.Fragment");
        }
        throw new IllegalArgumentException("Object was neither an Activity nor a Fragment.");
    }

    @RequiresApi(api=11)
    private static void showRationaleDialogFragment(@NonNull FragmentManager fragmentManager, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        RationaleDialogFragment.newInstance(positiveButton, negativeButton, rationale, requestCode, perms).show(fragmentManager, DIALOG_TAG);
    }

    private static void runAnnotatedMethods(@NonNull Object object, int requestCode) {
        Class<?> clazz = object.getClass();
        if (EasyPermissions.isUsingAndroidAnnotations(object)) {
            clazz = clazz.getSuperclass();
        }
        for (Method method : clazz.getDeclaredMethods()) {
            AfterPermissionGranted ann;
            if (!method.isAnnotationPresent(AfterPermissionGranted.class) || (ann = method.getAnnotation(AfterPermissionGranted.class)).value() != requestCode) continue;
            if (method.getParameterTypes().length > 0) {
                throw new RuntimeException("Cannot execute method " + method.getName() + " because it is non-void method and/or has input parameters.");
            }
            try {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)"runDefaultMethod:IllegalAccessException", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.e((String)TAG, (String)"runDefaultMethod:InvocationTargetException", (Throwable)e);
            }
        }
    }

    private static boolean isUsingAndroidAnnotations(@NonNull Object object) {
        if (!object.getClass().getSimpleName().endsWith("_")) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("org.androidannotations.api.view.HasViews");
            return clazz.isInstance(object);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static interface PermissionCallbacks
    extends ActivityCompat.OnRequestPermissionsResultCallback {
        public void onPermissionsGranted(int var1, List<String> var2);

        public void onPermissionsDenied(int var1, List<String> var2);
    }
}

