/*
 * Decompiled with CFR 0.152.
 */
package pub.devrel.easypermissions;

import android.app.Activity;
import android.content.DialogInterface;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import java.util.Arrays;
import pub.devrel.easypermissions.EasyPermissions;
import pub.devrel.easypermissions.RationaleDialogConfig;
import pub.devrel.easypermissions.RationaleDialogFragment;
import pub.devrel.easypermissions.RationaleDialogFragmentCompat;

class RationaleDialogClickListener
implements DialogInterface.OnClickListener {
    private Object mHost;
    private RationaleDialogConfig mConfig;
    private EasyPermissions.PermissionCallbacks mCallbacks;

    RationaleDialogClickListener(RationaleDialogFragmentCompat compatDialogFragment, RationaleDialogConfig config, EasyPermissions.PermissionCallbacks callbacks) {
        this.mHost = compatDialogFragment.getParentFragment() != null ? compatDialogFragment.getParentFragment() : compatDialogFragment.getActivity();
        this.mConfig = config;
        this.mCallbacks = callbacks;
    }

    @RequiresApi(api=11)
    RationaleDialogClickListener(RationaleDialogFragment dialogFragment, RationaleDialogConfig config, EasyPermissions.PermissionCallbacks callbacks) {
        this.mHost = Build.VERSION.SDK_INT >= 17 ? (dialogFragment.getParentFragment() != null ? dialogFragment.getParentFragment() : dialogFragment.getActivity()) : dialogFragment.getActivity();
        this.mConfig = config;
        this.mCallbacks = callbacks;
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            if (this.mHost instanceof Fragment) {
                ((Fragment)this.mHost).requestPermissions(this.mConfig.permissions, this.mConfig.requestCode);
            } else {
                ActivityCompat.requestPermissions((Activity)((FragmentActivity)this.mHost), (String[])this.mConfig.permissions, (int)this.mConfig.requestCode);
            }
        } else {
            this.notifyPermissionDenied();
        }
    }

    private void notifyPermissionDenied() {
        if (this.mCallbacks != null) {
            this.mCallbacks.onPermissionsDenied(this.mConfig.requestCode, Arrays.asList(this.mConfig.permissions));
        }
    }
}

