/*
 * Decompiled with CFR 0.152.
 */
package pub.devrel.easypermissions.helper;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.annotation.StringRes;
import java.util.List;
import pub.devrel.easypermissions.RationaleDialogFragment;
import pub.devrel.easypermissions.helper.ActivityPermissionHelper;
import pub.devrel.easypermissions.helper.FrameworkFragmentPermissionHelper;
import pub.devrel.easypermissions.helper.LowApiPermissionsHelper;
import pub.devrel.easypermissions.helper.SupportFragmentPermissionHelper;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public abstract class PermissionHelper<T> {
    private static final String TAG = "PermissionHelper";
    private T mHost;

    @NonNull
    public static PermissionHelper newInstance(Activity host) {
        if (Build.VERSION.SDK_INT < 23) {
            return new LowApiPermissionsHelper(host);
        }
        return new ActivityPermissionHelper(host);
    }

    @NonNull
    public static PermissionHelper newInstance(android.support.v4.app.Fragment host) {
        if (Build.VERSION.SDK_INT < 23) {
            return new LowApiPermissionsHelper(host);
        }
        return new SupportFragmentPermissionHelper(host);
    }

    @NonNull
    public static PermissionHelper newInstance(Fragment host) {
        if (Build.VERSION.SDK_INT < 23) {
            return new LowApiPermissionsHelper(host);
        }
        return new FrameworkFragmentPermissionHelper(host);
    }

    public PermissionHelper(@NonNull T host) {
        this.mHost = host;
    }

    public boolean shouldShowRationale(String ... perms) {
        for (String perm : perms) {
            if (!this.shouldShowRequestPermissionRationale(perm)) continue;
            return true;
        }
        return false;
    }

    public boolean somePermissionPermanentlyDenied(@NonNull List<String> perms) {
        for (String deniedPermission : perms) {
            if (!this.permissionPermanentlyDenied(deniedPermission)) continue;
            return true;
        }
        return false;
    }

    public boolean permissionPermanentlyDenied(@NonNull String perms) {
        return !this.shouldShowRequestPermissionRationale(perms);
    }

    public boolean somePermissionDenied(String ... perms) {
        return this.shouldShowRationale(perms);
    }

    @NonNull
    public T getHost() {
        return this.mHost;
    }

    public abstract void requestPermissions(@NonNull String var1, @StringRes int var2, @StringRes int var3, int var4, String ... var5);

    public abstract boolean shouldShowRequestPermissionRationale(@NonNull String var1);

    public abstract Context getContext();

    @RequiresApi(api=11)
    protected void showRationaleDialogFragment(@NonNull FragmentManager fragmentManager, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        RationaleDialogFragment.newInstance(positiveButton, negativeButton, rationale, requestCode, perms).show(fragmentManager, "RationaleDialogFragment");
    }
}

