
package ru.yandex.qatools.allure.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for step complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="step">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;all>
 *         &lt;element name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="title" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="attachments" type="{urn:model.allure.qatools.yandex.ru}attachments" minOccurs="0"/>
 *         &lt;element name="steps" type="{urn:model.allure.qatools.yandex.ru}steps" minOccurs="0"/>
 *       &lt;/all>
 *       &lt;attribute name="start" use="required" type="{http://www.w3.org/2001/XMLSchema}long" />
 *       &lt;attribute name="stop" use="required" type="{http://www.w3.org/2001/XMLSchema}long" />
 *       &lt;attribute name="status" use="required" type="{urn:model.allure.qatools.yandex.ru}status" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "step", propOrder = {

})
public class Step {

    @XmlElement(required = true)
    protected String name;
    protected String title;
    @XmlAttribute(name = "start", required = true)
    protected long start;
    @XmlAttribute(name = "stop", required = true)
    protected long stop;
    @XmlAttribute(name = "status", required = true)
    protected Status status;
    @XmlElementWrapper(name = "attachments")
    @XmlElement(name = "attachment")
    protected List<Attachment> attachments;
    @XmlElementWrapper(name = "steps")
    @XmlElement(name = "step")
    protected List<Step> steps;

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the title property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTitle(String value) {
        this.title = value;
    }

    /**
     * Gets the value of the start property.
     * 
     */
    public long getStart() {
        return start;
    }

    /**
     * Sets the value of the start property.
     * 
     */
    public void setStart(long value) {
        this.start = value;
    }

    /**
     * Gets the value of the stop property.
     * 
     */
    public long getStop() {
        return stop;
    }

    /**
     * Sets the value of the stop property.
     * 
     */
    public void setStop(long value) {
        this.stop = value;
    }

    /**
     * Gets the value of the status property.
     * 
     * @return
     *     possible object is
     *     {@link Status }
     *     
     */
    public Status getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     * 
     * @param value
     *     allowed object is
     *     {@link Status }
     *     
     */
    public void setStatus(Status value) {
        this.status = value;
    }

    public List<Attachment> getAttachments() {
        if (attachments == null) {
            attachments = new ArrayList<Attachment>();
        }
        return attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public List<Step> getSteps() {
        if (steps == null) {
            steps = new ArrayList<Step>();
        }
        return steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public Step withName(String value) {
        setName(value);
        return this;
    }

    public Step withTitle(String value) {
        setTitle(value);
        return this;
    }

    public Step withStart(long value) {
        setStart(value);
        return this;
    }

    public Step withStop(long value) {
        setStop(value);
        return this;
    }

    public Step withStatus(Status value) {
        setStatus(value);
        return this;
    }

    public Step withAttachments(Attachment... values) {
        if (values!= null) {
            for (Attachment value: values) {
                getAttachments().add(value);
            }
        }
        return this;
    }

    public Step withAttachments(Collection<Attachment> values) {
        if (values!= null) {
            getAttachments().addAll(values);
        }
        return this;
    }

    public Step withAttachments(List<Attachment> attachments) {
        setAttachments(attachments);
        return this;
    }

    public Step withSteps(Step... values) {
        if (values!= null) {
            for (Step value: values) {
                getSteps().add(value);
            }
        }
        return this;
    }

    public Step withSteps(Collection<Step> values) {
        if (values!= null) {
            getSteps().addAll(values);
        }
        return this;
    }

    public Step withSteps(List<Step> steps) {
        setSteps(steps);
        return this;
    }

}
