
package ru.yandex.qatools.allure.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for test-case-result complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="test-case-result">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;all>
 *         &lt;element name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="title" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="description" type="{urn:model.allure.qatools.yandex.ru}description" minOccurs="0"/>
 *         &lt;element name="failure" type="{urn:model.allure.qatools.yandex.ru}failure" minOccurs="0"/>
 *         &lt;element name="steps" type="{urn:model.allure.qatools.yandex.ru}steps" minOccurs="0"/>
 *         &lt;element name="attachments" type="{urn:model.allure.qatools.yandex.ru}attachments" minOccurs="0"/>
 *         &lt;element name="labels" type="{urn:model.allure.qatools.yandex.ru}labels" minOccurs="0"/>
 *         &lt;element name="parameters" type="{urn:model.allure.qatools.yandex.ru}parameters" minOccurs="0"/>
 *       &lt;/all>
 *       &lt;attribute name="start" use="required" type="{http://www.w3.org/2001/XMLSchema}long" />
 *       &lt;attribute name="stop" use="required" type="{http://www.w3.org/2001/XMLSchema}long" />
 *       &lt;attribute name="status" use="required" type="{urn:model.allure.qatools.yandex.ru}status" />
 *       &lt;attribute name="severity" use="required" type="{urn:model.allure.qatools.yandex.ru}severity-level" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "test-case-result", propOrder = {

})
public class TestCaseResult {

    @XmlElement(required = true)
    protected String name;
    protected String title;
    protected Description description;
    protected Failure failure;
    @XmlAttribute(name = "start", required = true)
    protected long start;
    @XmlAttribute(name = "stop", required = true)
    protected long stop;
    @XmlAttribute(name = "status", required = true)
    protected Status status;
    @XmlAttribute(name = "severity", required = true)
    protected SeverityLevel severity;
    @XmlElementWrapper(name = "steps")
    @XmlElement(name = "step")
    protected List<Step> steps;
    @XmlElementWrapper(name = "attachments")
    @XmlElement(name = "attachment")
    protected List<Attachment> attachments;
    @XmlElementWrapper(name = "labels")
    @XmlElement(name = "label")
    protected List<Label> labels;
    @XmlElementWrapper(name = "parameters")
    @XmlElement(name = "parameter")
    protected List<Parameter> parameters;

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the title property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTitle(String value) {
        this.title = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link Description }
     *     
     */
    public Description getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link Description }
     *     
     */
    public void setDescription(Description value) {
        this.description = value;
    }

    /**
     * Gets the value of the failure property.
     * 
     * @return
     *     possible object is
     *     {@link Failure }
     *     
     */
    public Failure getFailure() {
        return failure;
    }

    /**
     * Sets the value of the failure property.
     * 
     * @param value
     *     allowed object is
     *     {@link Failure }
     *     
     */
    public void setFailure(Failure value) {
        this.failure = value;
    }

    /**
     * Gets the value of the start property.
     * 
     */
    public long getStart() {
        return start;
    }

    /**
     * Sets the value of the start property.
     * 
     */
    public void setStart(long value) {
        this.start = value;
    }

    /**
     * Gets the value of the stop property.
     * 
     */
    public long getStop() {
        return stop;
    }

    /**
     * Sets the value of the stop property.
     * 
     */
    public void setStop(long value) {
        this.stop = value;
    }

    /**
     * Gets the value of the status property.
     * 
     * @return
     *     possible object is
     *     {@link Status }
     *     
     */
    public Status getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     * 
     * @param value
     *     allowed object is
     *     {@link Status }
     *     
     */
    public void setStatus(Status value) {
        this.status = value;
    }

    /**
     * Gets the value of the severity property.
     * 
     * @return
     *     possible object is
     *     {@link SeverityLevel }
     *     
     */
    public SeverityLevel getSeverity() {
        return severity;
    }

    /**
     * Sets the value of the severity property.
     * 
     * @param value
     *     allowed object is
     *     {@link SeverityLevel }
     *     
     */
    public void setSeverity(SeverityLevel value) {
        this.severity = value;
    }

    public List<Step> getSteps() {
        if (steps == null) {
            steps = new ArrayList<Step>();
        }
        return steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public List<Attachment> getAttachments() {
        if (attachments == null) {
            attachments = new ArrayList<Attachment>();
        }
        return attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public List<Label> getLabels() {
        if (labels == null) {
            labels = new ArrayList<Label>();
        }
        return labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public List<Parameter> getParameters() {
        if (parameters == null) {
            parameters = new ArrayList<Parameter>();
        }
        return parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public TestCaseResult withName(String value) {
        setName(value);
        return this;
    }

    public TestCaseResult withTitle(String value) {
        setTitle(value);
        return this;
    }

    public TestCaseResult withDescription(Description value) {
        setDescription(value);
        return this;
    }

    public TestCaseResult withFailure(Failure value) {
        setFailure(value);
        return this;
    }

    public TestCaseResult withStart(long value) {
        setStart(value);
        return this;
    }

    public TestCaseResult withStop(long value) {
        setStop(value);
        return this;
    }

    public TestCaseResult withStatus(Status value) {
        setStatus(value);
        return this;
    }

    public TestCaseResult withSeverity(SeverityLevel value) {
        setSeverity(value);
        return this;
    }

    public TestCaseResult withSteps(Step... values) {
        if (values!= null) {
            for (Step value: values) {
                getSteps().add(value);
            }
        }
        return this;
    }

    public TestCaseResult withSteps(Collection<Step> values) {
        if (values!= null) {
            getSteps().addAll(values);
        }
        return this;
    }

    public TestCaseResult withSteps(List<Step> steps) {
        setSteps(steps);
        return this;
    }

    public TestCaseResult withAttachments(Attachment... values) {
        if (values!= null) {
            for (Attachment value: values) {
                getAttachments().add(value);
            }
        }
        return this;
    }

    public TestCaseResult withAttachments(Collection<Attachment> values) {
        if (values!= null) {
            getAttachments().addAll(values);
        }
        return this;
    }

    public TestCaseResult withAttachments(List<Attachment> attachments) {
        setAttachments(attachments);
        return this;
    }

    public TestCaseResult withLabels(Label... values) {
        if (values!= null) {
            for (Label value: values) {
                getLabels().add(value);
            }
        }
        return this;
    }

    public TestCaseResult withLabels(Collection<Label> values) {
        if (values!= null) {
            getLabels().addAll(values);
        }
        return this;
    }

    public TestCaseResult withLabels(List<Label> labels) {
        setLabels(labels);
        return this;
    }

    public TestCaseResult withParameters(Parameter... values) {
        if (values!= null) {
            for (Parameter value: values) {
                getParameters().add(value);
            }
        }
        return this;
    }

    public TestCaseResult withParameters(Collection<Parameter> values) {
        if (values!= null) {
            getParameters().addAll(values);
        }
        return this;
    }

    public TestCaseResult withParameters(List<Parameter> parameters) {
        setParameters(parameters);
        return this;
    }

}
