/*
 * Decompiled with CFR 0.152.
 */
package skin.support.app;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.view.LayoutInflaterFactory;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.VectorEnabledTintResources;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import skin.support.app.SkinCompatViewInflater;
import skin.support.widget.SkinCompatSupportable;

public class SkinCompatDelegate
implements LayoutInflaterFactory {
    private final Context mContext;
    private SkinCompatViewInflater mSkinCompatViewInflater;
    private List<WeakReference<SkinCompatSupportable>> mSkinHelpers = new ArrayList<WeakReference<SkinCompatSupportable>>();

    private SkinCompatDelegate(Context context) {
        this.mContext = context;
    }

    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        View view = null;
        try {
            view = this.createView(parent, name, context, attrs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (view == null) {
            return null;
        }
        if (view instanceof SkinCompatSupportable) {
            this.mSkinHelpers.add(new WeakReference<SkinCompatSupportable>((SkinCompatSupportable)view));
        }
        return view;
    }

    public View createView(View parent, String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        boolean isPre21;
        boolean bl = isPre21 = Build.VERSION.SDK_INT < 21;
        if (this.mSkinCompatViewInflater == null) {
            this.mSkinCompatViewInflater = new SkinCompatViewInflater();
        }
        boolean inheritContext = isPre21 && this.shouldInheritContext((ViewParent)parent);
        return this.mSkinCompatViewInflater.createView(parent, name, context, attrs, inheritContext, isPre21, true, VectorEnabledTintResources.shouldBeUsed());
    }

    private boolean shouldInheritContext(ViewParent parent) {
        if (parent == null) {
            return false;
        }
        if (this.mContext instanceof Activity) {
            View windowDecor = ((Activity)this.mContext).getWindow().getDecorView();
            while (true) {
                if (parent == null) {
                    return true;
                }
                if (parent == windowDecor || !(parent instanceof View) || ViewCompat.isAttachedToWindow((View)((View)parent))) {
                    return false;
                }
                parent = parent.getParent();
            }
        }
        return false;
    }

    public static SkinCompatDelegate create(Context context) {
        return new SkinCompatDelegate(context);
    }

    public void applySkin() {
        if (this.mSkinHelpers != null && !this.mSkinHelpers.isEmpty()) {
            for (WeakReference<SkinCompatSupportable> ref : this.mSkinHelpers) {
                if (ref == null || ref.get() == null) continue;
                ((SkinCompatSupportable)ref.get()).applySkin();
            }
        }
    }
}

