/*
 * Decompiled with CFR 0.152.
 */
package skin.support.app;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.support.v7.view.ContextThemeWrapper;
import android.support.v7.widget.TintContextWrapper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.InflateException;
import android.view.View;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import skin.support.SkinCompatManager;
import skin.support.app.SkinLayoutInflater;
import skin.support.widget.SkinCompatAutoCompleteTextView;
import skin.support.widget.SkinCompatButton;
import skin.support.widget.SkinCompatCheckBox;
import skin.support.widget.SkinCompatCheckedTextView;
import skin.support.widget.SkinCompatEditText;
import skin.support.widget.SkinCompatFrameLayout;
import skin.support.widget.SkinCompatImageButton;
import skin.support.widget.SkinCompatImageView;
import skin.support.widget.SkinCompatLinearLayout;
import skin.support.widget.SkinCompatMultiAutoCompleteTextView;
import skin.support.widget.SkinCompatProgressBar;
import skin.support.widget.SkinCompatRadioButton;
import skin.support.widget.SkinCompatRadioGroup;
import skin.support.widget.SkinCompatRatingBar;
import skin.support.widget.SkinCompatRelativeLayout;
import skin.support.widget.SkinCompatScrollView;
import skin.support.widget.SkinCompatSeekBar;
import skin.support.widget.SkinCompatSpinner;
import skin.support.widget.SkinCompatSupportable;
import skin.support.widget.SkinCompatTextView;
import skin.support.widget.SkinCompatToolbar;
import skin.support.widget.SkinCompatView;

public class SkinCompatViewInflater {
    private static final Class<?>[] sConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    private static final int[] sOnClickAttrs = new int[]{16843375};
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.view.", "android.webkit."};
    private static final String LOG_TAG = "SkinCompatViewInflater";
    private static final Map<String, Constructor<? extends View>> sConstructorMap = new ArrayMap();
    private final Object[] mConstructorArgs = new Object[2];

    public final View createView(View parent, String name, @NonNull Context context, @NonNull AttributeSet attrs, boolean inheritContext, boolean readAndroidTheme, boolean readAppTheme, boolean wrapContext) {
        View view;
        Context originalContext = context;
        if (inheritContext && parent != null) {
            context = parent.getContext();
        }
        if (readAndroidTheme || readAppTheme) {
            context = SkinCompatViewInflater.themifyContext(context, attrs, readAndroidTheme, readAppTheme);
        }
        if (wrapContext) {
            context = TintContextWrapper.wrap((Context)context);
        }
        if ((view = this.createViewFromHackInflater(context, name, attrs)) == null) {
            view = this.createViewFromFV(context, name, attrs);
        }
        if (view == null) {
            view = this.createViewFromV7(context, name, attrs);
        }
        if (view == null) {
            view = this.createViewFromInflater(context, name, attrs);
        }
        if (view == null) {
            view = this.createViewFromTag(context, name, attrs);
        }
        if (view != null) {
            this.checkOnClickListener(view, attrs);
        }
        return view;
    }

    private View createViewFromHackInflater(Context context, String name, AttributeSet attrs) {
        SkinLayoutInflater inflater;
        View view = null;
        Iterator<SkinLayoutInflater> iterator = SkinCompatManager.getInstance().getHookInflaters().iterator();
        while (iterator.hasNext() && (view = (inflater = iterator.next()).createView(context, name, attrs)) == null) {
        }
        return view;
    }

    private View createViewFromFV(Context context, String name, AttributeSet attrs) {
        SkinCompatSupportable view = null;
        if (name.contains(".")) {
            return null;
        }
        switch (name) {
            case "View": {
                view = new SkinCompatView(context, attrs);
                break;
            }
            case "LinearLayout": {
                view = new SkinCompatLinearLayout(context, attrs);
                break;
            }
            case "RelativeLayout": {
                view = new SkinCompatRelativeLayout(context, attrs);
                break;
            }
            case "FrameLayout": {
                view = new SkinCompatFrameLayout(context, attrs);
                break;
            }
            case "TextView": {
                view = new SkinCompatTextView(context, attrs);
                break;
            }
            case "ImageView": {
                view = new SkinCompatImageView(context, attrs);
                break;
            }
            case "Button": {
                view = new SkinCompatButton(context, attrs);
                break;
            }
            case "EditText": {
                view = new SkinCompatEditText(context, attrs);
                break;
            }
            case "Spinner": {
                view = new SkinCompatSpinner(context, attrs);
                break;
            }
            case "ImageButton": {
                view = new SkinCompatImageButton(context, attrs);
                break;
            }
            case "CheckBox": {
                view = new SkinCompatCheckBox(context, attrs);
                break;
            }
            case "RadioButton": {
                view = new SkinCompatRadioButton(context, attrs);
                break;
            }
            case "RadioGroup": {
                view = new SkinCompatRadioGroup(context, attrs);
                break;
            }
            case "CheckedTextView": {
                view = new SkinCompatCheckedTextView(context, attrs);
                break;
            }
            case "AutoCompleteTextView": {
                view = new SkinCompatAutoCompleteTextView(context, attrs);
                break;
            }
            case "MultiAutoCompleteTextView": {
                view = new SkinCompatMultiAutoCompleteTextView(context, attrs);
                break;
            }
            case "RatingBar": {
                view = new SkinCompatRatingBar(context, attrs);
                break;
            }
            case "SeekBar": {
                view = new SkinCompatSeekBar(context, attrs);
                break;
            }
            case "ProgressBar": {
                view = new SkinCompatProgressBar(context, attrs);
                break;
            }
            case "ScrollView": {
                view = new SkinCompatScrollView(context, attrs);
            }
        }
        return view;
    }

    private View createViewFromV7(Context context, String name, AttributeSet attrs) {
        SkinCompatToolbar view = null;
        switch (name) {
            case "android.support.v7.widget.Toolbar": {
                view = new SkinCompatToolbar(context, attrs);
            }
        }
        return view;
    }

    private View createViewFromInflater(Context context, String name, AttributeSet attrs) {
        SkinLayoutInflater inflater;
        View view = null;
        Iterator<SkinLayoutInflater> iterator = SkinCompatManager.getInstance().getInflaters().iterator();
        while (iterator.hasNext() && (view = (inflater = iterator.next()).createView(context, name, attrs)) == null) {
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View createViewFromTag(Context context, String name, AttributeSet attrs) {
        if (name.equals("view")) {
            name = attrs.getAttributeValue(null, "class");
        }
        try {
            this.mConstructorArgs[0] = context;
            this.mConstructorArgs[1] = attrs;
            if (-1 == name.indexOf(46)) {
                for (int i = 0; i < sClassPrefixList.length; ++i) {
                    View view = this.createView(context, name, sClassPrefixList[i]);
                    if (view == null) continue;
                    View view2 = view;
                    return view2;
                }
                View i = null;
                return i;
            }
            View i = this.createView(context, name, null);
            return i;
        }
        catch (Exception e) {
            View view = null;
            return view;
        }
        finally {
            this.mConstructorArgs[0] = null;
            this.mConstructorArgs[1] = null;
        }
    }

    private void checkOnClickListener(View view, AttributeSet attrs) {
        Context context = view.getContext();
        if (!(context instanceof ContextWrapper) || Build.VERSION.SDK_INT >= 15 && !ViewCompat.hasOnClickListeners((View)view)) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, sOnClickAttrs);
        String handlerName = a.getString(0);
        if (handlerName != null) {
            view.setOnClickListener((View.OnClickListener)new DeclaredOnClickListener(view, handlerName));
        }
        a.recycle();
    }

    private View createView(Context context, String name, String prefix) throws ClassNotFoundException, InflateException {
        Constructor<? extends View> constructor = sConstructorMap.get(name);
        try {
            if (constructor == null) {
                Class<View> clazz = context.getClassLoader().loadClass(prefix != null ? prefix + name : name).asSubclass(View.class);
                constructor = clazz.getConstructor(sConstructorSignature);
                sConstructorMap.put(name, constructor);
            }
            constructor.setAccessible(true);
            return constructor.newInstance(this.mConstructorArgs);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Context themifyContext(Context context, AttributeSet attrs, boolean useAndroidTheme, boolean useAppTheme) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.View, 0, 0);
        int themeId = 0;
        if (useAndroidTheme) {
            themeId = a.getResourceId(R.styleable.View_android_theme, 0);
        }
        if (useAppTheme && themeId == 0 && (themeId = a.getResourceId(R.styleable.View_theme, 0)) != 0) {
            Log.i((String)LOG_TAG, (String)"app:theme is now deprecated. Please move to using android:theme instead.");
        }
        a.recycle();
        if (!(themeId == 0 || context instanceof ContextThemeWrapper && ((ContextThemeWrapper)context).getThemeResId() == themeId)) {
            context = new ContextThemeWrapper(context, themeId);
        }
        return context;
    }

    private static class DeclaredOnClickListener
    implements View.OnClickListener {
        private final View mHostView;
        private final String mMethodName;
        private Method mResolvedMethod;
        private Context mResolvedContext;

        public DeclaredOnClickListener(@NonNull View hostView, @NonNull String methodName) {
            this.mHostView = hostView;
            this.mMethodName = methodName;
        }

        public void onClick(@NonNull View v) {
            if (this.mResolvedMethod == null) {
                this.resolveMethod(this.mHostView.getContext(), this.mMethodName);
            }
            try {
                this.mResolvedMethod.invoke((Object)this.mResolvedContext, v);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not execute non-public method for android:onClick", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Could not execute method for android:onClick", e);
            }
        }

        @NonNull
        private void resolveMethod(@Nullable Context context, @NonNull String name) {
            while (context != null) {
                try {
                    Method method;
                    if (!context.isRestricted() && (method = context.getClass().getMethod(this.mMethodName, View.class)) != null) {
                        this.mResolvedMethod = method;
                        this.mResolvedContext = context;
                        return;
                    }
                }
                catch (NoSuchMethodException method) {
                    // empty catch block
                }
                if (context instanceof ContextWrapper) {
                    context = ((ContextWrapper)context).getBaseContext();
                    continue;
                }
                context = null;
            }
            int id = this.mHostView.getId();
            String idText = id == -1 ? "" : " with id '" + this.mHostView.getContext().getResources().getResourceEntryName(id) + "'";
            throw new IllegalStateException("Could not find method " + this.mMethodName + "(View) in a parent or ancestor Context for android:onClick attribute defined on view " + this.mHostView.getClass() + idText);
        }
    }
}

